package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxCode;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxCodeStatusEnum;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

/**
 * @Auther lv
 * @Date 2023/2/24
 * 失败情况：
 * 1。税编记录不存在
 * 2。税编不是叶子节点：sfhzx：Y
 * 3。不在有效期内：小于qyrq启用日期 || 大于tyrq停用日期
 * 4。简称是否跟查询到的税编一致
 * todo 5。税率范围应在多税率范围内
 */
public class TaxCodeValidator {
    public static void validate(String itemName, TaxCode taxCode) {
        if (null == taxCode) {
            throw new TXWR000004Exception("税编不存在，禁止开票");
        }

        if (TaxCodeStatusEnum.TAX_RATE_STATUS_Y.getStatus().equals(taxCode.getSummarizeItemFlag())) {
            throw new TXWR000004Exception("该税编是汇总项，禁止开票");
        }

        if (!StringUtils.equals(taxCode.getItemShortName(), itemName)) {
            throw new TXWR000004Exception("税编有误，禁止开票");
        }

        Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date startDate = taxCode.getStartDate();
        Date endDate = taxCode.getEndDate();

        // 启用日期不可为空
        if (null == startDate || startDate.compareTo(now) > 0) {
            throw new TXWR000004Exception("税编不在有效期范围内，禁止开票");
        }

        // 停用日期可为空
        if (null != endDate && endDate.compareTo(now) < 0) {
            throw new TXWR000004Exception("税编不在有效期范围内，禁止开票");
        }
    }
}
