package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @author Thj
 * @createdAt: 2023/2/9 14:42
 * @Description:
 */
@Data
public class BaseInvoiceInfo {

    /**
     * 蓝字发票标志
     * 0：蓝字发票
     * 1：红字发票
     */
    @Alias("蓝字发票标志")
    @NotEmpty
    @Length(max = 1)
    @Pattern(regexp = "0|1")
    private String invoiceFlag;

    /**
     * 发票票种
     * 01：全电专
     * 02：全电普
     */
    @Alias("发票票种")
    @NotEmpty
    @Length(max = 2)
    @Pattern(regexp = "0[1-2]")
    private String invoiceType;

    /**
     * 特定要素（非必须）
     * 空：非特定要素 空:""
     * 01：成品油发票
     * 02：稀土发票
     * 03：建筑服务发票
     * 04：货物运输服务发票
     * 05：不动产销售服务发票
     * 06：不动产租赁服务发票
     * 07：代收车船税
     * 08：通行费
     * 09：旅客运输服务发票
     * 10：医疗服务（住院）发票
     * 11：医疗服务（门诊）发票
     * 12：自产农产品销售发票
     * 13	拖拉机和联合收割机发票
     * 14：机动车
     * 15：二手车
     * 16：农产品收购发票
     * 17：光伏收购发票
     * 18：卷烟发票
     */
    @Alias("特定要素")
    @Length(max = 2)
    @Pattern(regexp = "^$|0[1-9]|1[0-8]")
    private String invoiceStyleType;

    /**
     * 增值税即征即退代码（非必须）
     * 空：非增值税即征即退
     * 01：软件产品发票
     * 02：资源综合利用产品发票
     * 03：管道运输服务发票
     * 04：有形动产融资租赁服务
     * 05：有形动产融资性售后回租服务发票
     * 06：新型墙体材料发票
     * 07：风力发电产品发票
     * 08：光伏发电产品发票
     * 09：动漫软件产品发票
     * 10：飞机维修劳务发票
     * 11：黄金发票
     * 12：铂金发票
     */
    @Alias("增值税即征即退代码")
    @Length(max = 2)
    @Pattern(regexp = "^$|0[1-9]|1[0-2]")
    private String vatRefundType;

    /**
     * 结算方式（非必须）
     * 01：现金
     * 02：银行转账
     * 03：票据
     * 04：第三方支付
     * 05：预付卡
     * 99：其他
     */
    @Alias("结算方式")
    @Length(max = 2)
    @Pattern(regexp = "^$|0[1-5]|99")
    private String settlementMode;

    /**
     * 备注（非必须）
     */
    @Alias("备注")
    @Length(max = 460)
    private String remark;
}
