package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @author Thj
 * @createdAt: 2023/2/8 16:36
 * @Description:
 */
@Data
public class SellerInfo {

    /**
     * 销售方统一社会信用代码/纳税人识别号/身份证件号码
     */
    @Alias("销售方统一社会信用代码")
    @NotEmpty
    @Length(max = 26)
    @Pattern(regexp = "[A-Z0-9]+")
    private String sellerTaxNo;

    /**
     * 销售方名称
     */
    @Alias("销售方名称")
    @NotEmpty
    @Length(max = 300)
    private String sellerName;

    /**
     * 销售方地址（非必须）
     */
    @Alias("销售方地址")
    @Length(max = 300)
    private String sellerAddress;

    /**
     * 销售方电话（非必须）
     */
    @Alias("销售方电话")
    @Length(max = 60)
    private String sellerTel;

    /**
     * 销售方开户行（非必须）
     */
    @Alias("销售方开户行")
    @Length(max = 120)
    private String sellerBankName;

    /**
     * 销售方账号（非必须）
     */
    @Alias("销售方账号")
    @Length(max = 100)
    private String sellerBankAccount;

    /**
     * 收款银行名称（非必须）
     */
    @Alias("收款银行名称")
    @Length(max = 120)
    private String payeeBankName;

    /**
     * 收款银行账号（非必须）
     */
    @Alias("收款银行账号")
    @Length(max = 100)
    private String payeeBankAccount;
}
