package com.xforceplus.taxware.chestnut.check.model.base;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author zhenmengying
 * @date 2023/3/1
 * @describe:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaxRate {

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 参数状态
     * 0：启用
     * 1：停用
     */
    private String paraFlag;

    /**
     * 有效期起
     * 时间格式：
     * yyyy-MM-dd
     */
    private String startDate;

    /**
     * 有效期止（非必须）
     * 时间格式：
     * yyyy-MM-dd
     */
    private String endDate;

    /**
     * 停用日期（非必须）
     * 时间格式：
     * yyyy-MM-dd
     */
    private String stopDate;
}
