package com.xforceplus.taxware.chestnut.check.model.validator.taxpayer;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxpayerInfo;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.SellerTaxpayerStatusEnum;

/**
 * @Auther lv
 * @Date 2023/2/13
 * @Descrption 纳税人基础信息校验：
 * 	未查询到纳税人基本信息，本地无纳税人基本信息。
 * 	纳税人信息中“纳税人状态”不是“03（正常）”、“09（报验）”中的任意一个。
 */
public class TaxpayerInfoValidator {

    /**
     * 	未查询到纳税人基本信息，本地无纳税人基本信息。
     * 	纳税人信息中“纳税人状态”不是“03（正常）”、“09（报验）”中的任意一个。
     * @param taxpayerInfo
     */
    public static void validate(TaxpayerInfo taxpayerInfo) {

        if(taxpayerInfo == null){
            throw new TXWR000004Exception("未查询到纳税人基本信息，禁止开票");
        }

        /**
         * 开票方纳税人状态
         * 01：受理
         * 02：筹建期
         * 03：正常
         * 04：停业
         * 05：非正常
         * 06：清算
         * 07：注销
         * 08：非正常户注销
         * 09：报验
         * 10：核销报验
         * 11：中断缴费
         * 12：恢复缴费
         * 13：简易注销无异议
         * 99：其他
         */
        String sellerTaxpayerStatus = taxpayerInfo.getSellerTaxpayerStatus();
        if(!SellerTaxpayerStatusEnum.SELLER_TAXPAYER_STATUS_03.getStatus().equals(sellerTaxpayerStatus) && !SellerTaxpayerStatusEnum.SELLER_TAXPAYER_STATUS_09.getStatus().equals(sellerTaxpayerStatus)){
            throw new TXWR000004Exception("该纳税人状态为"+ SellerTaxpayerStatusEnum.fromStatus(sellerTaxpayerStatus).getStatusDesc() +"，禁止开票");
        }
    }
}
