/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.redletter;

import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.base.BuyerInfo;
import com.xforceplus.taxware.chestnut.check.model.base.OriginalInvoiceInfo;
import com.xforceplus.taxware.chestnut.check.model.base.SellerInfo;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

public class RedLetterValidator {
    @Alias(value="\u5f55\u5165\u65b9\u8eab\u4efd")
    @NotEmpty(message="\u5f55\u5165\u65b9\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=1, message="\u5f55\u5165\u65b9\u8eab\u4efd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71")
    @Pattern(regexp="0|1", message="\u5f55\u5165\u65b9\u8eab\u4efd\u4e0d\u662f\u6709\u6548\u503c")
    private @NotEmpty(message="\u5f55\u5165\u65b9\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=1, message="\u5f55\u5165\u65b9\u8eab\u4efd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71") @Pattern(regexp="0|1", message="\u5f55\u5165\u65b9\u8eab\u4efd\u4e0d\u662f\u6709\u6548\u503c") String applyIdentity;
    private SellerInfo sellerInfo;
    private BuyerInfo buyerInfo;
    private OriginalInvoiceInfo originalInvoiceInfo;
    @Alias(value="\u7ea2\u5b57\u51b2\u9500\u91d1\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal reverseAmountWithoutTax;
    @Alias(value="\u7ea2\u5b57\u51b2\u9500\u7a0e\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal reverseTaxAmount;
    @Alias(value="\u7ea2\u5b57\u53d1\u7968\u51b2\u7ea2\u539f\u56e0\u4ee3\u7801")
    @NotEmpty
    @Pattern(regexp="0[1-4]")
    private @NotEmpty @Pattern(regexp="0[1-4]") String applyReason;
    private List<Detail> details;

    public ValidateResult validate() {
        ValidateResult result = BasicValidator.validate(this);
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getSellerInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getBuyerInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getOriginalInvoiceInfo()));
        List<Detail> detailList = this.getDetails();
        if (detailList == null || detailList.size() == 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        for (Detail detail : detailList) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
        }
        if (result.isSuccess()) {
            result = BasicValidator.mergeValidateResult(result, this.validateData());
        }
        return result;
    }

    private ValidateResult validateData() {
        ArrayList<ValidateResult.ErrorInfo> errorInfoList = new ArrayList<ValidateResult.ErrorInfo>();
        if (this.getReverseAmountWithoutTax().compareTo(this.getOriginalInvoiceInfo().getInvoiceAmountInfo().getAmountWithoutTax()) > 0) {
            errorInfoList.add(new ValidateResult.ErrorInfo("\u7ea2\u7968\u5f00\u5177\u91d1\u989d\u5927\u4e8e\u5bf9\u5e94\u84dd\u7968\u5f00\u5177\u91d1\u989d"));
        }
        if (errorInfoList.size() > 0) {
            return ValidateResult.fail(errorInfoList);
        }
        return ValidateResult.success();
    }

    public String getApplyIdentity() {
        return this.applyIdentity;
    }

    public SellerInfo getSellerInfo() {
        return this.sellerInfo;
    }

    public BuyerInfo getBuyerInfo() {
        return this.buyerInfo;
    }

    public OriginalInvoiceInfo getOriginalInvoiceInfo() {
        return this.originalInvoiceInfo;
    }

    public BigDecimal getReverseAmountWithoutTax() {
        return this.reverseAmountWithoutTax;
    }

    public BigDecimal getReverseTaxAmount() {
        return this.reverseTaxAmount;
    }

    public String getApplyReason() {
        return this.applyReason;
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void setApplyIdentity(String applyIdentity) {
        this.applyIdentity = applyIdentity;
    }

    public void setSellerInfo(SellerInfo sellerInfo) {
        this.sellerInfo = sellerInfo;
    }

    public void setBuyerInfo(BuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public void setOriginalInvoiceInfo(OriginalInvoiceInfo originalInvoiceInfo) {
        this.originalInvoiceInfo = originalInvoiceInfo;
    }

    public void setReverseAmountWithoutTax(BigDecimal reverseAmountWithoutTax) {
        this.reverseAmountWithoutTax = reverseAmountWithoutTax;
    }

    public void setReverseTaxAmount(BigDecimal reverseTaxAmount) {
        this.reverseTaxAmount = reverseTaxAmount;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedLetterValidator)) {
            return false;
        }
        RedLetterValidator other = (RedLetterValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applyIdentity = this.getApplyIdentity();
        String other$applyIdentity = other.getApplyIdentity();
        if (this$applyIdentity == null ? other$applyIdentity != null : !this$applyIdentity.equals(other$applyIdentity)) {
            return false;
        }
        SellerInfo this$sellerInfo = this.getSellerInfo();
        SellerInfo other$sellerInfo = other.getSellerInfo();
        if (this$sellerInfo == null ? other$sellerInfo != null : !((Object)this$sellerInfo).equals(other$sellerInfo)) {
            return false;
        }
        BuyerInfo this$buyerInfo = this.getBuyerInfo();
        BuyerInfo other$buyerInfo = other.getBuyerInfo();
        if (this$buyerInfo == null ? other$buyerInfo != null : !((Object)this$buyerInfo).equals(other$buyerInfo)) {
            return false;
        }
        OriginalInvoiceInfo this$originalInvoiceInfo = this.getOriginalInvoiceInfo();
        OriginalInvoiceInfo other$originalInvoiceInfo = other.getOriginalInvoiceInfo();
        if (this$originalInvoiceInfo == null ? other$originalInvoiceInfo != null : !((Object)this$originalInvoiceInfo).equals(other$originalInvoiceInfo)) {
            return false;
        }
        BigDecimal this$reverseAmountWithoutTax = this.getReverseAmountWithoutTax();
        BigDecimal other$reverseAmountWithoutTax = other.getReverseAmountWithoutTax();
        if (this$reverseAmountWithoutTax == null ? other$reverseAmountWithoutTax != null : !((Object)this$reverseAmountWithoutTax).equals(other$reverseAmountWithoutTax)) {
            return false;
        }
        BigDecimal this$reverseTaxAmount = this.getReverseTaxAmount();
        BigDecimal other$reverseTaxAmount = other.getReverseTaxAmount();
        if (this$reverseTaxAmount == null ? other$reverseTaxAmount != null : !((Object)this$reverseTaxAmount).equals(other$reverseTaxAmount)) {
            return false;
        }
        String this$applyReason = this.getApplyReason();
        String other$applyReason = other.getApplyReason();
        if (this$applyReason == null ? other$applyReason != null : !this$applyReason.equals(other$applyReason)) {
            return false;
        }
        List<Detail> this$details = this.getDetails();
        List<Detail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedLetterValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applyIdentity = this.getApplyIdentity();
        result = result * 59 + ($applyIdentity == null ? 43 : $applyIdentity.hashCode());
        SellerInfo $sellerInfo = this.getSellerInfo();
        result = result * 59 + ($sellerInfo == null ? 43 : ((Object)$sellerInfo).hashCode());
        BuyerInfo $buyerInfo = this.getBuyerInfo();
        result = result * 59 + ($buyerInfo == null ? 43 : ((Object)$buyerInfo).hashCode());
        OriginalInvoiceInfo $originalInvoiceInfo = this.getOriginalInvoiceInfo();
        result = result * 59 + ($originalInvoiceInfo == null ? 43 : ((Object)$originalInvoiceInfo).hashCode());
        BigDecimal $reverseAmountWithoutTax = this.getReverseAmountWithoutTax();
        result = result * 59 + ($reverseAmountWithoutTax == null ? 43 : ((Object)$reverseAmountWithoutTax).hashCode());
        BigDecimal $reverseTaxAmount = this.getReverseTaxAmount();
        result = result * 59 + ($reverseTaxAmount == null ? 43 : ((Object)$reverseTaxAmount).hashCode());
        String $applyReason = this.getApplyReason();
        result = result * 59 + ($applyReason == null ? 43 : $applyReason.hashCode());
        List<Detail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "RedLetterValidator(applyIdentity=" + this.getApplyIdentity() + ", sellerInfo=" + this.getSellerInfo() + ", buyerInfo=" + this.getBuyerInfo() + ", originalInvoiceInfo=" + this.getOriginalInvoiceInfo() + ", reverseAmountWithoutTax=" + this.getReverseAmountWithoutTax() + ", reverseTaxAmount=" + this.getReverseTaxAmount() + ", applyReason=" + this.getApplyReason() + ", details=" + this.getDetails() + ")";
    }

    public static class Detail
    extends BaseDetail {
        @Alias(value="\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0")
        @NotEmpty
        @Length(max=300)
        private @NotEmpty @Length(max=300) String itemSimpleName;
        @Alias(value="\u5546\u54c1\u670d\u52a1\u7b80\u79f0")
        @NotEmpty
        @Length(max=120)
        private @NotEmpty @Length(max=120) String itemShortName;

        public String getItemSimpleName() {
            return this.itemSimpleName;
        }

        @Override
        public String getItemShortName() {
            return this.itemShortName;
        }

        public void setItemSimpleName(String itemSimpleName) {
            this.itemSimpleName = itemSimpleName;
        }

        public void setItemShortName(String itemShortName) {
            this.itemShortName = itemShortName;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$itemSimpleName = this.getItemSimpleName();
            String other$itemSimpleName = other.getItemSimpleName();
            if (this$itemSimpleName == null ? other$itemSimpleName != null : !this$itemSimpleName.equals(other$itemSimpleName)) {
                return false;
            }
            String this$itemShortName = this.getItemShortName();
            String other$itemShortName = other.getItemShortName();
            return !(this$itemShortName == null ? other$itemShortName != null : !this$itemShortName.equals(other$itemShortName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $itemSimpleName = this.getItemSimpleName();
            result = result * 59 + ($itemSimpleName == null ? 43 : $itemSimpleName.hashCode());
            String $itemShortName = this.getItemShortName();
            result = result * 59 + ($itemShortName == null ? 43 : $itemShortName.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "RedLetterValidator.Detail(itemSimpleName=" + this.getItemSimpleName() + ", itemShortName=" + this.getItemShortName() + ")";
        }
    }
}

