/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import cn.hutool.core.util.StrUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxCode;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxCodeStatusEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TaxCodeValidator {
    public static void validate(String itemName, TaxCode taxCode) {
        if (null == taxCode) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u5f00\u7968");
        }
        if (TaxCodeStatusEnum.TAX_RATE_STATUS_Y.getStatus().equals(taxCode.getSummarizeItemFlag())) {
            throw new TXWR000004Exception("\u8be5\u7a0e\u7f16\u662f\u6c47\u603b\u9879\uff0c\u7981\u6b62\u5f00\u7968");
        }
        if (!StringUtils.equals((CharSequence)taxCode.getItemShortName(), (CharSequence)itemName)) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u6709\u8bef\uff0c\u7981\u6b62\u5f00\u7968");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        try {
            Date endDate;
            if (StrUtil.isBlank((CharSequence)taxCode.getStartDate())) {
                throw new TXWR000004Exception(String.format("\u542f\u7528\u65e5\u671f\u4e3a\u7a7a\uff0c\u7981\u6b62\u5f00\u7968", new Object[0]));
            }
            Date startDate = format.parse(taxCode.getStartDate());
            if (null == startDate || startDate.compareTo(now) > 0) {
                throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968");
            }
            if (StrUtil.isNotBlank((CharSequence)taxCode.getEndDate()) && null != (endDate = format.parse(taxCode.getEndDate())) && endDate.compareTo(now) < 0) {
                throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968");
            }
        }
        catch (ParseException e) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u6709\u8bef\uff0c\u7981\u6b62\u5f00\u7968");
        }
    }
}

