/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import cn.hutool.core.util.StrUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxCode;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxCodeStatusEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TaxCodeValidator {
    public static void validate(String itemName, TaxCode taxCode) {
        if (null == taxCode) {
            throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u5f00\u7968", itemName));
        }
        if (!StringUtils.equals((CharSequence)taxCode.getItemShortName(), (CharSequence)itemName)) {
            throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u7b80\u79f0\u6709\u8bef\uff0c\u671f\u671b\u7b80\u79f0[%s], \u5b9e\u9645\u7b80\u79f0[%s], \u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo(), taxCode.getItemShortName(), itemName));
        }
        if (TaxCodeStatusEnum.TAX_RATE_STATUS_Y.getStatus().equals(taxCode.getSummarizeItemFlag())) {
            throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u6c47\u603b\u9879\u6807\u8bc6\u9519\u8bef\uff0c\u8be5\u7a0e\u7f16\u662f\u6c47\u603b\u9879\uff0c\u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo()));
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        try {
            Date endDate;
            if (StrUtil.isBlank((CharSequence)taxCode.getStartDate())) {
                throw new TXWR000004Exception(String.format(String.format("\u7a0e\u7f16[%s]\u542f\u7528\u65e5\u671f\u4e3a\u7a7a\uff0c\u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo()), new Object[0]));
            }
            Date startDate = format.parse(taxCode.getStartDate());
            if (null == startDate || startDate.compareTo(now) > 0) {
                throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u542f\u7528\u65e5\u671f\u4e3a[%s], \u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo(), taxCode.getStartDate()));
            }
            if (StrUtil.isNotBlank((CharSequence)taxCode.getEndDate()) && null != (endDate = format.parse(taxCode.getEndDate())) && endDate.compareTo(now) < 0) {
                throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u505c\u7528\u65e5\u671f\u4e3a[%s], \u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo(), taxCode.getEndDate()));
            }
        }
        catch (ParseException e) {
            throw new TXWR000004Exception(String.format("\u7a0e\u7f16[%s]\u65f6\u95f4\u6709\u8bef\uff0c\u7981\u6b62\u5f00\u7968", taxCode.getGoodsTaxNo()));
        }
    }
}

