/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import cn.hutool.core.util.StrUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.base.TaxRate;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxRateStatusEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class TaxRateValidator {
    public static void validate(List<BaseDetail> baseDetails, List<TaxRate> taxRateList) {
        baseDetails.stream().forEach(baseDetail -> {
            TaxRate taxRate = taxRateList.stream().filter(x -> baseDetail.getTaxRate().compareTo(x.getTaxRate()) == 0).findAny().orElseThrow(() -> new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u5f00\u7968", baseDetail.getTaxRate())));
            System.out.println(String.format("validator rate -> %s", taxRate));
            String paraFlag = taxRate.getParaFlag();
            if (!TaxRateStatusEnum.TAX_RATE_STATUS_0.getStatus().equals(paraFlag)) {
                throw new TXWR000004Exception(String.format("\u7a0e\u7387[%s]\u72b6\u6001\u5f53\u524d\u72b6\u6001\u4e3a\u505c\u7528\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
            try {
                Date endDate;
                Date stopDate;
                if (StrUtil.isBlank((CharSequence)taxRate.getStartDate())) {
                    throw new TXWR000004Exception(String.format("[%s]\u542f\u7528\u65e5\u671f\u4e3a\u7a7a\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
                }
                Date startDate = format.parse(taxRate.getStartDate());
                if (null == startDate || startDate.compareTo(now) > 0) {
                    throw new TXWR000004Exception(String.format("\u7a0e\u7387[%s]\u542f\u7528\u65e5\u671f\u4e3a[%s]\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate(), taxRate.getStartDate()));
                }
                if (StrUtil.isNotBlank((CharSequence)taxRate.getStopDate()) && null != (stopDate = format.parse(taxRate.getStopDate())) && stopDate.compareTo(now) < 0) {
                    throw new TXWR000004Exception(String.format("\u7a0e\u7387[%s]\u505c\u7528\u65e5\u671f\u4e3a[%s]\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate(), taxRate.getStopDate()));
                }
                if (StrUtil.isNotBlank((CharSequence)taxRate.getEndDate()) && null != (endDate = format.parse(taxRate.getEndDate())) && endDate.compareTo(now) < 0) {
                    throw new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u5df2\u505c\u7528\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
                }
            }
            catch (ParseException e) {
                throw new TXWR000004Exception(String.format("\u7a0e\u7387[%s]\u65f6\u95f4\u6709\u8bef\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
        });
    }
}

