/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.redletter;

import cn.hutool.core.util.StrUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000002Exception;
import com.xforceplus.taxware.chestnut.check.model.base.InvoiceAmountInfo;
import com.xforceplus.taxware.chestnut.check.model.base.InvoiceStatusInfo;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStatusProvider;
import com.xforceplus.taxware.chestnut.check.model.common.RedInvoiceHistoryProvider;
import com.xforceplus.taxware.chestnut.check.model.constant.ApplyReasonEnum;
import com.xforceplus.taxware.chestnut.check.model.validator.invoice.InvoiceBaseValidator;
import com.xforceplus.taxware.chestnut.check.model.validator.redletter.RedLetterValidator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RedLetterVsOriginalInvoiceValidator {
    public static void validate(RedLetterValidator redLetter, InvoiceBaseValidator invoiceBase, RedInvoiceHistoryProvider redInvoiceHistoryProvider, InvoiceStatusProvider invoiceStatusProvider) {
        RedLetterVsOriginalInvoiceValidator.BaseBusinessCheck(redLetter, invoiceBase);
        HashMap<Integer, InvoiceBaseValidator.InvoiceDetail> indexInfo = new HashMap<Integer, InvoiceBaseValidator.InvoiceDetail>();
        invoiceBase.getInvoiceDetailList().forEach(detail -> indexInfo.put(detail.getRowNum(), (InvoiceBaseValidator.InvoiceDetail)detail));
        HashMap<String, Boolean> goodsTaxNoStartWithMixedCase = new HashMap<String, Boolean>();
        for (RedLetterValidator.Detail detail2 : redLetter.getDetails()) {
            InvoiceBaseValidator.InvoiceDetail originalDetail = (InvoiceBaseValidator.InvoiceDetail)indexInfo.get(detail2.getOriginalRowNum());
            RedLetterVsOriginalInvoiceValidator.handleDiscountCase(indexInfo, detail2, originalDetail, redLetter.getApplyReason());
            RedLetterVsOriginalInvoiceValidator.checkNegativeAmount(detail2);
            RedLetterVsOriginalInvoiceValidator.checkModifyInfoWithApplyReason(redLetter, detail2, originalDetail);
            String goodsTaxNoStartWithValue = detail2.getGoodsTaxNo().substring(0, 1);
            if (goodsTaxNoStartWithMixedCase.containsKey(goodsTaxNoStartWithValue)) continue;
            goodsTaxNoStartWithMixedCase.put(goodsTaxNoStartWithValue, true);
        }
        RedLetterVsOriginalInvoiceValidator.checkGoodsTaxNoWithApplyReason(redLetter, goodsTaxNoStartWithMixedCase);
        RedLetterVsOriginalInvoiceValidator.checkHistoryRedInvoiceDetailLimit(redLetter, redInvoiceHistoryProvider, indexInfo);
        RedLetterVsOriginalInvoiceValidator.checkInvoiceCheckStatus(redLetter, invoiceBase, invoiceStatusProvider);
    }

    private static void BaseBusinessCheck(RedLetterValidator redLetter, InvoiceBaseValidator invoiceBase) {
        InvoiceAmountInfo originalAmountInfo = redLetter.getOriginalInvoiceInfo().getInvoiceAmountInfo();
        if (redLetter.getReverseAmountWithoutTax().abs().compareTo(invoiceBase.getInvoiceAmountInfo().getAmountWithoutTax()) > 0) {
            throw new TXWR000002Exception("\u7ea2\u7968\u5f00\u5177\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u5f00\u5177\u91d1\u989d");
        }
        if (!invoiceBase.getInvoiceBaseInfo().getInvoiceType().equals(redLetter.getOriginalInvoiceInfo().getOriginalInvoiceType())) {
            throw new TXWR000002Exception("\u53d1\u7968\u7c7b\u578b\u4e0d\u5339\u914d");
        }
    }

    private static void handleDiscountCase(Map<Integer, InvoiceBaseValidator.InvoiceDetail> indexInfo, RedLetterValidator.Detail detail, InvoiceBaseValidator.InvoiceDetail originalDetail, String applyReason) {
        if ("02".equals(originalDetail.getDiscountType())) {
            InvoiceBaseValidator.InvoiceDetail discountDetail = indexInfo.get(detail.getOriginalRowNum() + 1);
            if (!"01".equals(discountDetail.getDiscountType())) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u5bf9\u5e94\u539f\u84dd\u7968\u6298\u6263\u4fe1\u606f\u6807\u5fd7\u4e0d\u5339\u914d", detail.getRowNum()));
            }
            if (discountDetail.getTaxAmount().compareTo(new BigDecimal(0)) > 0 || discountDetail.getAmountWithoutTax().compareTo(new BigDecimal(0)) > 0 || !StrUtil.isEmpty((CharSequence)discountDetail.getQuantity()) && new BigDecimal(discountDetail.getQuantity()).compareTo(new BigDecimal(0)) > 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u5bf9\u5e94\u539f\u84dd\u7968\u6298\u6263\u884c\u7684\u6570\u91cf\u3001\u91d1\u989d\u6216\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0", detail.getRowNum()));
            }
            originalDetail.setTaxAmount(originalDetail.getTaxAmount().add(discountDetail.getTaxAmount()));
            originalDetail.setAmountWithoutTax(originalDetail.getAmountWithoutTax().add(discountDetail.getAmountWithoutTax()));
            if (StrUtil.isEmpty((CharSequence)originalDetail.getQuantity()) || StrUtil.isEmpty((CharSequence)detail.getQuantity()) || StrUtil.isEmpty((CharSequence)originalDetail.getUnitPrice()) || StrUtil.isEmpty((CharSequence)detail.getUnitPrice())) {
                return;
            }
            if (ApplyReasonEnum.RETURN.getValue().equals(applyReason) || ApplyReasonEnum.BREAK.getValue().equals(applyReason)) {
                if (new BigDecimal(originalDetail.getQuantity()).compareTo(new BigDecimal(detail.getQuantity()).abs()) < 0) {
                    throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\uff0c\u9500\u8d27\u9000\u56de\u548c\u670d\u52a1\u7ec8\u6b62\u65f6\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u539f\u84dd\u7968\u88ab\u6298\u6263\u884c\u6570\u91cf", detail.getRowNum()));
                }
            } else if (new BigDecimal(originalDetail.getQuantity()).compareTo(new BigDecimal(detail.getQuantity()).abs()) != 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\uff0c\u7ea2\u51b2\u539f\u56e0\u975e\u9500\u8d27\u9000\u56de\u548c\u670d\u52a1\u7ec8\u6b62\u65f6\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u6570\u91cf\u5fc5\u987b\u4e0e\u539f\u84dd\u7968\u88ab\u6298\u6263\u884c\u4fdd\u6301\u4e00\u81f4", detail.getRowNum()));
            }
            if (new BigDecimal(detail.getUnitPrice()).multiply(new BigDecimal(originalDetail.getQuantity())).subtract(originalDetail.getAmountWithoutTax()).abs().compareTo(new BigDecimal("0.01")) > 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u9700\u6ee1\u8db3|(\u5355\u4ef7*\u84dd\u7968\u6570\u91cf)-(\u84dd\u7968\u88ab\u6298\u6263\u884c\u91d1\u989d+\u84dd\u7968\u6298\u6263\u884c\u91d1\u989d)|<=0.01", detail.getRowNum()));
            }
        }
    }

    private static void checkNegativeAmount(RedLetterValidator.Detail detail) {
        if (detail.getAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
            throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a\u6b63\u6570", detail.getRowNum()));
        }
        if (detail.getTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
            throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u4e3a\u6b63\u6570", detail.getRowNum()));
        }
    }

    private static void checkModifyInfoWithApplyReason(RedLetterValidator redLetter, RedLetterValidator.Detail detail, InvoiceBaseValidator.InvoiceDetail originalDetail) {
        if (!Objects.equals(originalDetail.getGoodsTaxNo(), detail.getGoodsTaxNo()) || !Objects.equals(originalDetail.getItemName(), detail.getItemName()) || originalDetail.getTaxRate().compareTo(detail.getTaxRate()) != 0) {
            throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u548c\u539f\u84dd\u7968\u660e\u7ec6\u5546\u54c1\u5185\u5bb9\u5b58\u5728\u4e0d\u4e00\u81f4\u7684\u60c5\u51b5", detail.getRowNum()));
        }
        Boolean isNeedCheckQuantityOrUnitPrice = true;
        if (StrUtil.isEmpty((CharSequence)detail.getQuantity()) && StrUtil.isEmpty((CharSequence)originalDetail.getQuantity()) && StrUtil.isEmpty((CharSequence)detail.getUnitPrice()) && StrUtil.isEmpty((CharSequence)originalDetail.getUnitPrice())) {
            isNeedCheckQuantityOrUnitPrice = false;
        } else if (Objects.equals("02", originalDetail.getDiscountType()) || Objects.equals("01", originalDetail.getDiscountType())) {
            isNeedCheckQuantityOrUnitPrice = false;
        }
        Boolean isMatchQuantity = isNeedCheckQuantityOrUnitPrice != false && new BigDecimal(originalDetail.getQuantity()).compareTo(new BigDecimal(detail.getQuantity()).abs()) == 0 || isNeedCheckQuantityOrUnitPrice == false;
        Boolean isMatchUnitPrice = isNeedCheckQuantityOrUnitPrice != false && new BigDecimal(originalDetail.getUnitPrice()).compareTo(new BigDecimal(detail.getUnitPrice()).abs()) == 0 || isNeedCheckQuantityOrUnitPrice == false;
        Boolean isMatchTaxAmount = originalDetail.getTaxAmount().compareTo(detail.getTaxAmount().abs()) == 0;
        Boolean isMatchAmountWithoutTax = originalDetail.getAmountWithoutTax().compareTo(detail.getAmountWithoutTax().abs()) == 0;
        if (ApplyReasonEnum.WRONG.getValue().equals(redLetter.getApplyReason())) {
            if (!(isMatchUnitPrice.booleanValue() && isMatchQuantity.booleanValue() && isMatchTaxAmount.booleanValue() && isMatchAmountWithoutTax.booleanValue())) {
                throw new TXWR000002Exception(String.format("\u5f00\u5177\u6709\u8bef\u65f6\uff0c\u7b2c%s\u884c\u660e\u7ec6\u548c\u539f\u84dd\u7968\u91d1\u989d\u3001\u6570\u91cf\u548c\u5355\u4ef7\u5b58\u5728\u4e0d\u4e00\u81f4\u60c5\u51b5", detail.getRowNum()));
            }
        } else if (ApplyReasonEnum.RETURN.getValue().equals(redLetter.getApplyReason())) {
            if (!isMatchUnitPrice.booleanValue()) {
                throw new TXWR000002Exception(String.format("\u9500\u8d27\u9000\u56de\u65f6\uff0c\u7b2c%s\u884c\u660e\u7ec6\u53ea\u5141\u8bb8\u4fee\u6539\u6570\u91cf", detail.getRowNum()));
            }
        } else if (ApplyReasonEnum.BREAK.getValue().equals(redLetter.getApplyReason())) {
            if (!isMatchUnitPrice.booleanValue()) {
                throw new TXWR000002Exception(String.format("\u670d\u52a1\u4e2d\u6b62\u65f6\uff0c\u7b2c%s\u884c\u660e\u7ec6\u53ea\u5141\u8bb8\u4fee\u6539\u91d1\u989d\u3001\u6570\u91cf", detail.getRowNum()));
            }
        } else if (!(!ApplyReasonEnum.DISCOUNT.getValue().equals(redLetter.getApplyReason()) || isMatchUnitPrice.booleanValue() && isMatchQuantity.booleanValue())) {
            throw new TXWR000002Exception(String.format("\u9500\u552e\u6298\u8ba9\u65f6\uff0c\u7b2c%s\u884c\u660e\u7ec6\u4e0d\u80fd\u4fee\u6539\u5355\u4ef7\u548c\u6570\u91cf", detail.getRowNum()));
        }
    }

    private static void checkGoodsTaxNoWithApplyReason(RedLetterValidator redLetter, Map<String, Boolean> goodsTaxNoStartWithMixedCase) {
        boolean isGoods = goodsTaxNoStartWithMixedCase.containsKey("1") || goodsTaxNoStartWithMixedCase.containsKey("2");
        boolean isService = goodsTaxNoStartWithMixedCase.containsKey("3");
        if (isGoods && isService) {
            return;
        }
        if (isGoods && ApplyReasonEnum.BREAK.getValue().equals(redLetter.getApplyReason())) {
            throw new TXWR000002Exception("\u5546\u54c1\u7f16\u7801\u662f1\u62162\u6253\u5934\uff0c\u7ea2\u51b2\u539f\u56e0\u4e0d\u5141\u8bb8\u9009\u62e9\u670d\u52a1\u4e2d\u6b62");
        }
        if (isService && ApplyReasonEnum.RETURN.getValue().equals(redLetter.getApplyReason())) {
            throw new TXWR000002Exception("\u5546\u54c1\u7f16\u7801\u662f3\u6253\u5934\uff0c\u7ea2\u51b2\u539f\u56e0\u4e0d\u5141\u8bb8\u9009\u62e9\u9500\u552e\u9000\u56de");
        }
    }

    private static void checkHistoryRedInvoiceDetailLimit(RedLetterValidator redLetter, RedInvoiceHistoryProvider redInvoiceHistoryProvider, Map<Integer, InvoiceBaseValidator.InvoiceDetail> indexInfo) {
        if (redInvoiceHistoryProvider == null) {
            return;
        }
        List<InvoiceBaseValidator> redInvoiceHistoryList = redInvoiceHistoryProvider.provide();
        HashMap detailTotalAmountWithoutTax = new HashMap();
        HashMap detailTotalTaxAmount = new HashMap();
        HashMap detailTotalQuantity = new HashMap();
        redInvoiceHistoryList.forEach(redInvoiceHistory -> redInvoiceHistory.getInvoiceDetailList().forEach(detail -> {
            if (detail.getOriginalRowNum() == null) {
                throw new TXWR000002Exception(String.format("\u67e5\u8be2\u5230\u7684\u5386\u53f2\u5df2\u5f00\u7ea2\u7968\u660e\u7ec6\u5bf9\u5e94\u539f\u84dd\u7968\u660e\u7ec6\u6570\u636e\u7f3a\u5931", new Object[0]));
            }
            if (detailTotalAmountWithoutTax.containsKey(detail.getOriginalRowNum())) {
                detailTotalAmountWithoutTax.put(detail.getOriginalRowNum(), ((BigDecimal)detailTotalAmountWithoutTax.get(detail.getOriginalRowNum())).add(detail.getAmountWithoutTax()));
            } else {
                detailTotalAmountWithoutTax.put(detail.getOriginalRowNum(), detail.getAmountWithoutTax());
            }
            if (detailTotalTaxAmount.containsKey(detail.getOriginalRowNum())) {
                detailTotalTaxAmount.put(detail.getOriginalRowNum(), ((BigDecimal)detailTotalTaxAmount.get(detail.getOriginalRowNum())).add(detail.getTaxAmount()));
            } else {
                detailTotalTaxAmount.put(detail.getOriginalRowNum(), detail.getTaxAmount());
            }
            if (!StrUtil.isEmpty((CharSequence)detail.getQuantity()) && detailTotalQuantity.containsKey(detail.getOriginalRowNum())) {
                detailTotalQuantity.put(detail.getOriginalRowNum(), ((BigDecimal)detailTotalQuantity.get(detail.getOriginalRowNum())).add(new BigDecimal(detail.getQuantity())));
            } else {
                BigDecimal quantity = StringUtils.isBlank((CharSequence)detail.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(detail.getQuantity());
                detailTotalQuantity.put(detail.getOriginalRowNum(), quantity);
            }
        }));
        redLetter.getDetails().forEach(redLetterDetail -> {
            InvoiceBaseValidator.InvoiceDetail originalDetail = (InvoiceBaseValidator.InvoiceDetail)indexInfo.get(redLetterDetail.getOriginalRowNum());
            if (detailTotalAmountWithoutTax.get(redLetterDetail.getRowNum()) != null && ((BigDecimal)detailTotalAmountWithoutTax.get(redLetterDetail.getRowNum())).add(redLetterDetail.getAmountWithoutTax()).add(originalDetail.getAmountWithoutTax()).compareTo(new BigDecimal(0)) < 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u7ea2\u51b2\u91d1\u989d\u8d85\u8fc7\u539f\u84dd\u7968\u53ef\u7ea2\u51b2\u5269\u4f59\u989d\u5ea6", redLetterDetail.getRowNum()));
            }
            if (detailTotalTaxAmount.get(redLetterDetail.getRowNum()) != null && ((BigDecimal)detailTotalTaxAmount.get(redLetterDetail.getRowNum())).add(redLetterDetail.getTaxAmount()).add(originalDetail.getTaxAmount()).compareTo(new BigDecimal(0)) < 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u7ea2\u51b2\u7a0e\u989d\u8d85\u8fc7\u539f\u84dd\u7968\u53ef\u7ea2\u51b2\u5269\u4f59\u989d\u5ea6", redLetterDetail.getRowNum()));
            }
            if (!Objects.equals(redLetter.getApplyReason(), ApplyReasonEnum.DISCOUNT.getValue()) && detailTotalQuantity.get(redLetterDetail.getRowNum()) != null && !StrUtil.isEmpty((CharSequence)redLetterDetail.getQuantity()) && ((BigDecimal)detailTotalQuantity.get(redLetterDetail.getRowNum())).add(new BigDecimal(redLetterDetail.getQuantity())).add(new BigDecimal(originalDetail.getQuantity())).compareTo(new BigDecimal(0)) < 0) {
                throw new TXWR000002Exception(String.format("\u7b2c%s\u884c\u660e\u7ec6\u7ea2\u51b2\u6570\u91cf\u8d85\u8fc7\u539f\u84dd\u7968\u53ef\u7ea2\u51b2\u5269\u4f59\u6570\u91cf", redLetterDetail.getRowNum()));
            }
        });
    }

    private static void checkInvoiceCheckStatus(RedLetterValidator redLetter, InvoiceBaseValidator invoiceBase, InvoiceStatusProvider invoiceStatusProvider) {
        if (invoiceStatusProvider == null || invoiceStatusProvider.provide() == null) {
            return;
        }
        Boolean isMatchTaxAmount = invoiceBase.getInvoiceAmountInfo().getTaxAmount().compareTo(redLetter.getReverseTaxAmount().abs()) == 0;
        Boolean isMatchAmountWithoutTax = invoiceBase.getInvoiceAmountInfo().getAmountWithoutTax().compareTo(redLetter.getReverseAmountWithoutTax().abs()) == 0;
        Boolean isFull = isMatchAmountWithoutTax != false && isMatchTaxAmount != false;
        InvoiceStatusInfo invoiceStatusInfo = invoiceStatusProvider.provide();
        if (Objects.equals(invoiceStatusInfo.getExciseUsage(), "00") && ("01".equals(invoiceStatusInfo.getEntryStatus()) || "03".equals(invoiceStatusInfo.getEntryStatus()))) {
            Boolean isRecycling = "16".equals(invoiceBase.getInvoiceBaseInfo().getInvoiceStyleType()) || "17".equals(invoiceBase.getInvoiceBaseInfo().getInvoiceStyleType());
            if (!isRecycling.booleanValue() && !"0".equals(redLetter.getApplyIdentity())) {
                throw new TXWR000002Exception("\u539f\u84dd\u7968\u672a\u5165\u8d26\u4e14\u672a\u52fe\u9009\uff0c\u53ea\u80fd\u9500\u65b9\u53d1\u8d77");
            }
            if (!isFull.booleanValue()) {
                throw new TXWR000002Exception("\u539f\u84dd\u7968\u672a\u5165\u8d26\u4e14\u672a\u52fe\u9009\uff0c\u53ea\u80fd\u5168\u989d\u7ea2\u51b2");
            }
        }
    }
}

