package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * 原蓝票发票信息
 */
@Data
public class OriginalInvoiceInfo {

    /**
     * 蓝字发票代码（非必须）
     */
    @Alias("蓝字发票代码")
    @Length(max = 12)
    private String originalInvoiceCode;

    /**
     * 蓝字发票号码
     */
    @Alias("蓝字发票号码")
    @NotEmpty
    @Length(max = 20)
    private String originalInvoiceNo;

    /**
     * 是否纸质发票标志
     * Y：纸质发票
     * N：电子发票
     */
    @Alias("是否纸质发票标志")
    @NotEmpty
    @Length(max = 1)
    @Pattern(regexp = "Y|N")
    private String paperInvoiceFlag;

    /**
     * 蓝字发票开票日期
     * yyyy-MM-dd HH:mm:ss
     */
    @Alias("蓝字发票开票日期")
    @NotNull
    private Date originalDateTimeIssued;

    /**
     * 蓝字发票票种代码
     * 01: 增值税专用发票
     * 02: 普通发票
     * 03: 机动车统一销售发票
     * 04: 二手车统一销售发票
     */
    @Alias("蓝字发票票种代码")
    @NotEmpty
    @Length(max = 2)
    @Pattern(regexp = "01|02|03|04")
    private String originalInvoiceType;

    /**
     * 发票金额信息
     */
    private InvoiceAmountInfo invoiceAmountInfo;

    /**
     * 蓝字发票特定要素类型代码（非必须）
     * 01：成品油发票
     * 02：稀土发票
     * 03：建筑服务发票
     * 04：货物运输服务发票
     * 05：不动产销售服务发票
     * 06：不动产租赁服务发票
     * 07：代收车船税
     * 08：通行费
     * 09：旅客运输服务发票
     * 10：医疗服务（住院）发票
     * 11：医疗服务（门诊）发票
     * 12：自产农产品销售发票
     * 13 拖拉机和联合收割机发票
     * 14：机动车
     * 15：二手车
     * 16：农产品收购发票
     * 17：光伏收购发票
     * 18：卷烟发票
     */
    @Alias("蓝字发票特定要素类型代码")
    @Length(max = 2)
    private String invoiceStyleType;
}
