package com.xforceplus.taxware.chestnut.check.model.constant;

/**
 * @author Thj
 * @createdAt: 2023/12/13 18:21
 * @Description:
 */
public enum AreaUnitEnum {
    PINGFANGMI("01", "平方米"),
    MU("02", "亩"),
    PINGFANGMI_SPECIAL("03", "㎡"),
    PINGFANGKM("04", "平方千米"),
    GONGQING("05", "公顷"),
    PINGFANGFENMI_SPECIAL("06", "h㎡"),
    PINGFANGQIANMI_SPECIAL("07", "k㎡"),
    KONGGONGLI("08", "孔公里");

    private String unitCode;

    private String unitName;

    AreaUnitEnum(String unitCode, String unitName) {
        this.unitCode = unitCode;
        this.unitName = unitName;
    }

    public String getUnitCode() {
        return unitCode;
    }

    public String getUnitName() {
        return unitName;
    }

    public static AreaUnitEnum fromCode(String unitCode) {
        final AreaUnitEnum[] values = AreaUnitEnum.values();

        for (AreaUnitEnum areaUnitEnum : values) {
            if (areaUnitEnum.unitCode.equals(unitCode)) {
                return areaUnitEnum;
            }
        }

        return null;
    }
}
