/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.base.BaseInvoiceInfo;
import com.xforceplus.taxware.chestnut.check.model.base.BuyerInfo;
import com.xforceplus.taxware.chestnut.check.model.base.InvoiceAmountInfo;
import com.xforceplus.taxware.chestnut.check.model.base.OperatorInfo;
import com.xforceplus.taxware.chestnut.check.model.base.RedLetterInfo;
import com.xforceplus.taxware.chestnut.check.model.base.SellerInfo;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ScriptAssert;

@ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.check.model.validator.invoice.InvoiceBaseValidator.isValidNotEmptyRedLetterInfo(_this)", message="\u6807\u5fd7\u4e3a\u7ea2\u7968\uff0c\u5bf9\u5e94\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u548c\u539f\u84dd\u7968\u53d1\u7968\u53f7\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a")})
public class InvoiceBaseValidator {
    private BaseInvoiceInfo invoiceBaseInfo;
    private SellerInfo sellerInfo;
    private BuyerInfo buyerInfo;
    private InvoiceAmountInfo invoiceAmountInfo;
    private OperatorInfo operatorInfo;
    private RedLetterInfo redLetterInfo;
    private List<InvoiceDetail> invoiceDetailList;

    public static boolean isValidNotEmptyRedLetterInfo(InvoiceBaseValidator invoiceInfo) {
        BaseInvoiceInfo invoiceBaseInfo = invoiceInfo.getInvoiceBaseInfo();
        RedLetterInfo redInfo = invoiceInfo.getRedLetterInfo();
        if ("1".equals(invoiceBaseInfo.getInvoiceFlag()) && redInfo != null) {
            return redInfo.getRedLetterNumber() != null && redInfo.getRedLetterNumber().trim().length() > 0 && redInfo.getOriginalInvoiceNo() != null && redInfo.getOriginalInvoiceNo().trim().length() > 0;
        }
        return true;
    }

    public ValidateResult validate() {
        ValidateResult result = BasicValidator.validate(this);
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getInvoiceBaseInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getSellerInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getBuyerInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getInvoiceAmountInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getOperatorInfo()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getRedLetterInfo()));
        List<InvoiceDetail> detailList = this.getInvoiceDetailList();
        if (detailList == null || detailList.size() == 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        for (InvoiceDetail detail : detailList) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
        }
        if (result.isSuccess()) {
            result = BasicValidator.mergeValidateResult(result, this.validateData());
        }
        return result;
    }

    private ValidateResult validateData() {
        BigDecimal invoiceTotalTaxAmount;
        BigDecimal invoiceTotalAmount;
        String buyerTaxNo;
        String sellerTaxNo;
        ValidateResult result = ValidateResult.success();
        if ("0".equals(this.invoiceBaseInfo.getInvoiceFlag()) && (StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getRedLetterNumber()) || StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getOriginalInvoiceNo()) || StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getOriginalDateIssued()))) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u84dd\u5b57\u53d1\u7968\u5bf9\u5e94\u7684\u7ea2\u5b57\u53d1\u7968\u76f8\u5173\u53c2\u6570\u5e94\u4e3a\u7a7a"));
        }
        if (Objects.equals(sellerTaxNo = this.getSellerInfo().getSellerTaxNo(), buyerTaxNo = this.getBuyerInfo().getBuyerTaxNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u586b\u5199\u7684\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u548c\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u76f8\u540c\uff0c\u5426\u5219\u963b\u65ad\u53d1\u7968\u4e0a\u4f20\u3002"));
        }
        if ((invoiceTotalAmount = this.getInvoiceAmountInfo().getAmountWithTax()).compareTo((invoiceTotalTaxAmount = this.getInvoiceAmountInfo().getTaxAmount()).add(this.getInvoiceAmountInfo().getAmountWithoutTax())) != 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u7968\u9762\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u91d1\u989d\u52a0\u7a0e\u989d"));
        }
        if ("1".equals(this.invoiceBaseInfo.getInvoiceFlag())) {
            return result;
        }
        BigDecimal detailTotalAmount = BigDecimal.valueOf(0L);
        BigDecimal detailTotalTaxAmount = BigDecimal.valueOf(0L);
        List<InvoiceDetail> detailList = this.getInvoiceDetailList();
        for (int i = 0; i < detailList.size(); ++i) {
            InvoiceDetail detail = detailList.get(i);
            ValidateResult validateDataResult = detail.validateData();
            result = BasicValidator.mergeValidateResult(result, validateDataResult);
            if ("1".equals(this.getInvoiceBaseInfo().getInvoiceFlag()) && detail.getOriginalRowNum() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (i + 1 != detail.getRowNum()) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5e8f\u53f7\u4e0d\u662f\u4ece1\u5f00\u59cb\u6216\u4e0d\u8fde\u7eed\u6216\u91cd\u590d"));
                return result;
            }
            if (detail.getRowNum() == 1) {
                if ("02".equals(detail.getDiscountType())) {
                    if (detailList.size() < 2) {
                        result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u7b2c\u4e00\u884c\u662f\u88ab\u6298\u6263\u884c,\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u5c11\u4e8e\u4e24\u884c"));
                        return result;
                    }
                    if (!detailList.get(1).getDiscountType().equals("01")) {
                        result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u88ab\u6298\u6263\u884c\u7684\u4e0b\u4e00\u884c\u5fc5\u987b\u4e3a\u6298\u6263\u884c"));
                    }
                } else if ("01".equals(detail.getDiscountType())) {
                    result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u7b2c\u4e00\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c"));
                }
            }
            if (!("00".equals(detail.getDiscountType()) || detail.getOriginalRowNum() == null && detail.getDeduction() == null)) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6298\u6263\u884c\u4e0e\u88ab\u6298\u6263\u884c\u201c\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7\u201d\u3001\u201c\u6263\u9664\u989d\u201d\u5fc5\u987b\u4e3a\u7a7a\u3002"));
            }
            if ("01".equals(detail.getDiscountType()) && (StringUtils.isNotBlank((CharSequence)detail.getSpecifications()) || StringUtils.isNotBlank((CharSequence)detail.getUnitPrice()) || StringUtils.isNotBlank((CharSequence)detail.getUnit()) || StringUtils.isNotBlank((CharSequence)detail.getQuantity()))) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6298\u6263\u884c\u201c\u89c4\u683c\u578b\u53f7\u201d\u3001\u201c\u5355\u4ef7\u201d\u3001\u201c\u5355\u4f4d\u201d\u3001\u201c\u6570\u91cf\u201d\u5fc5\u987b\u4e3a\u7a7a\uff1b"));
            }
            if ("01".equals(detail.getDiscountType()) && !detailList.get(i - 1).getItemName().equals(detail.getItemName())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u5546\u54c1\u540d\u79f0\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4", i + 1)));
            }
            if ("01".equals(detail.getDiscountType()) && detailList.get(i - 1).getTaxRate().compareTo(detail.getTaxRate()) != 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4", i + 1)));
            }
            if ("01".equals(detail.getDiscountType()) && !detailList.get(i - 1).getGoodsTaxNo().equals(detail.getGoodsTaxNo())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4", i + 1)));
            }
            if ("01".equals(detail.getDiscountType()) && !Objects.equals(detailList.get(i - 1).getTaxIncentivesType(), detail.getTaxIncentivesType())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4", i + 1)));
            }
            detailTotalAmount = detailTotalAmount.add(detail.getAmountWithTax());
            detailTotalTaxAmount = detailTotalTaxAmount.add(detail.getAmountWithoutTax().multiply(detail.getTaxRate()));
        }
        if (detailTotalAmount.subtract(invoiceTotalAmount).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(0.01)) > 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5408\u8ba1\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.01\u5143"));
        }
        if (detailTotalTaxAmount.subtract(invoiceTotalTaxAmount).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(1.27)) > 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5408\u8ba1\u7a0e\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee1.27\u5143"));
        }
        return result;
    }

    public BaseInvoiceInfo getInvoiceBaseInfo() {
        return this.invoiceBaseInfo;
    }

    public SellerInfo getSellerInfo() {
        return this.sellerInfo;
    }

    public BuyerInfo getBuyerInfo() {
        return this.buyerInfo;
    }

    public InvoiceAmountInfo getInvoiceAmountInfo() {
        return this.invoiceAmountInfo;
    }

    public OperatorInfo getOperatorInfo() {
        return this.operatorInfo;
    }

    public RedLetterInfo getRedLetterInfo() {
        return this.redLetterInfo;
    }

    public List<InvoiceDetail> getInvoiceDetailList() {
        return this.invoiceDetailList;
    }

    public void setInvoiceBaseInfo(BaseInvoiceInfo invoiceBaseInfo) {
        this.invoiceBaseInfo = invoiceBaseInfo;
    }

    public void setSellerInfo(SellerInfo sellerInfo) {
        this.sellerInfo = sellerInfo;
    }

    public void setBuyerInfo(BuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public void setInvoiceAmountInfo(InvoiceAmountInfo invoiceAmountInfo) {
        this.invoiceAmountInfo = invoiceAmountInfo;
    }

    public void setOperatorInfo(OperatorInfo operatorInfo) {
        this.operatorInfo = operatorInfo;
    }

    public void setRedLetterInfo(RedLetterInfo redLetterInfo) {
        this.redLetterInfo = redLetterInfo;
    }

    public void setInvoiceDetailList(List<InvoiceDetail> invoiceDetailList) {
        this.invoiceDetailList = invoiceDetailList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceBaseValidator)) {
            return false;
        }
        InvoiceBaseValidator other = (InvoiceBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseInvoiceInfo this$invoiceBaseInfo = this.getInvoiceBaseInfo();
        BaseInvoiceInfo other$invoiceBaseInfo = other.getInvoiceBaseInfo();
        if (this$invoiceBaseInfo == null ? other$invoiceBaseInfo != null : !((Object)this$invoiceBaseInfo).equals(other$invoiceBaseInfo)) {
            return false;
        }
        SellerInfo this$sellerInfo = this.getSellerInfo();
        SellerInfo other$sellerInfo = other.getSellerInfo();
        if (this$sellerInfo == null ? other$sellerInfo != null : !((Object)this$sellerInfo).equals(other$sellerInfo)) {
            return false;
        }
        BuyerInfo this$buyerInfo = this.getBuyerInfo();
        BuyerInfo other$buyerInfo = other.getBuyerInfo();
        if (this$buyerInfo == null ? other$buyerInfo != null : !((Object)this$buyerInfo).equals(other$buyerInfo)) {
            return false;
        }
        InvoiceAmountInfo this$invoiceAmountInfo = this.getInvoiceAmountInfo();
        InvoiceAmountInfo other$invoiceAmountInfo = other.getInvoiceAmountInfo();
        if (this$invoiceAmountInfo == null ? other$invoiceAmountInfo != null : !((Object)this$invoiceAmountInfo).equals(other$invoiceAmountInfo)) {
            return false;
        }
        OperatorInfo this$operatorInfo = this.getOperatorInfo();
        OperatorInfo other$operatorInfo = other.getOperatorInfo();
        if (this$operatorInfo == null ? other$operatorInfo != null : !((Object)this$operatorInfo).equals(other$operatorInfo)) {
            return false;
        }
        RedLetterInfo this$redLetterInfo = this.getRedLetterInfo();
        RedLetterInfo other$redLetterInfo = other.getRedLetterInfo();
        if (this$redLetterInfo == null ? other$redLetterInfo != null : !((Object)this$redLetterInfo).equals(other$redLetterInfo)) {
            return false;
        }
        List<InvoiceDetail> this$invoiceDetailList = this.getInvoiceDetailList();
        List<InvoiceDetail> other$invoiceDetailList = other.getInvoiceDetailList();
        return !(this$invoiceDetailList == null ? other$invoiceDetailList != null : !((Object)this$invoiceDetailList).equals(other$invoiceDetailList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoiceBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseInvoiceInfo $invoiceBaseInfo = this.getInvoiceBaseInfo();
        result = result * 59 + ($invoiceBaseInfo == null ? 43 : ((Object)$invoiceBaseInfo).hashCode());
        SellerInfo $sellerInfo = this.getSellerInfo();
        result = result * 59 + ($sellerInfo == null ? 43 : ((Object)$sellerInfo).hashCode());
        BuyerInfo $buyerInfo = this.getBuyerInfo();
        result = result * 59 + ($buyerInfo == null ? 43 : ((Object)$buyerInfo).hashCode());
        InvoiceAmountInfo $invoiceAmountInfo = this.getInvoiceAmountInfo();
        result = result * 59 + ($invoiceAmountInfo == null ? 43 : ((Object)$invoiceAmountInfo).hashCode());
        OperatorInfo $operatorInfo = this.getOperatorInfo();
        result = result * 59 + ($operatorInfo == null ? 43 : ((Object)$operatorInfo).hashCode());
        RedLetterInfo $redLetterInfo = this.getRedLetterInfo();
        result = result * 59 + ($redLetterInfo == null ? 43 : ((Object)$redLetterInfo).hashCode());
        List<InvoiceDetail> $invoiceDetailList = this.getInvoiceDetailList();
        result = result * 59 + ($invoiceDetailList == null ? 43 : ((Object)$invoiceDetailList).hashCode());
        return result;
    }

    public String toString() {
        return "InvoiceBaseValidator(invoiceBaseInfo=" + this.getInvoiceBaseInfo() + ", sellerInfo=" + this.getSellerInfo() + ", buyerInfo=" + this.getBuyerInfo() + ", invoiceAmountInfo=" + this.getInvoiceAmountInfo() + ", operatorInfo=" + this.getOperatorInfo() + ", redLetterInfo=" + this.getRedLetterInfo() + ", invoiceDetailList=" + this.getInvoiceDetailList() + ")";
    }

    public static class Additional {
        @Alias(value="\u9644\u52a0\u8981\u7d20\u540d\u79f0")
        @Length(max=200)
        @JSONField(name="fjysmc")
        private @Length(max=200) String additionalElementName;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u7c7b\u578b")
        @Length(max=200)
        @JSONField(name="fjyslx")
        private @Length(max=200) String additionalElementType;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u503c")
        @Length(max=200)
        @JSONField(name="fjysz")
        private @Length(max=200) String additionalElementValue;

        public String getAdditionalElementName() {
            return this.additionalElementName;
        }

        public String getAdditionalElementType() {
            return this.additionalElementType;
        }

        public String getAdditionalElementValue() {
            return this.additionalElementValue;
        }

        public void setAdditionalElementName(String additionalElementName) {
            this.additionalElementName = additionalElementName;
        }

        public void setAdditionalElementType(String additionalElementType) {
            this.additionalElementType = additionalElementType;
        }

        public void setAdditionalElementValue(String additionalElementValue) {
            this.additionalElementValue = additionalElementValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Additional)) {
                return false;
            }
            Additional other = (Additional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$additionalElementName = this.getAdditionalElementName();
            String other$additionalElementName = other.getAdditionalElementName();
            if (this$additionalElementName == null ? other$additionalElementName != null : !this$additionalElementName.equals(other$additionalElementName)) {
                return false;
            }
            String this$additionalElementType = this.getAdditionalElementType();
            String other$additionalElementType = other.getAdditionalElementType();
            if (this$additionalElementType == null ? other$additionalElementType != null : !this$additionalElementType.equals(other$additionalElementType)) {
                return false;
            }
            String this$additionalElementValue = this.getAdditionalElementValue();
            String other$additionalElementValue = other.getAdditionalElementValue();
            return !(this$additionalElementValue == null ? other$additionalElementValue != null : !this$additionalElementValue.equals(other$additionalElementValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Additional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $additionalElementName = this.getAdditionalElementName();
            result = result * 59 + ($additionalElementName == null ? 43 : $additionalElementName.hashCode());
            String $additionalElementType = this.getAdditionalElementType();
            result = result * 59 + ($additionalElementType == null ? 43 : $additionalElementType.hashCode());
            String $additionalElementValue = this.getAdditionalElementValue();
            result = result * 59 + ($additionalElementValue == null ? 43 : $additionalElementValue.hashCode());
            return result;
        }

        public String toString() {
            return "InvoiceBaseValidator.Additional(additionalElementName=" + this.getAdditionalElementName() + ", additionalElementType=" + this.getAdditionalElementType() + ", additionalElementValue=" + this.getAdditionalElementValue() + ")";
        }
    }

    public static class InvoiceDetail
    extends BaseDetail {
        @Alias(value="\u542b\u7a0e\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="hsje")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;
        @Alias(value="\u6263\u9664\u989d")
        @Digits(integer=18, fraction=2)
        @JSONField(name="kce")
        private @Digits(integer=18, fraction=2) BigDecimal deduction;
        @Alias(value="\u53d1\u7968\u884c\u6027\u8d28")
        @NotEmpty
        @Length(max=2)
        @Pattern(regexp="0[0-2]")
        @JSONField(name="fphxz")
        private @NotEmpty @Length(max=2) @Pattern(regexp="0[0-2]") String discountType;
        @Alias(value="\u4f18\u60e0\u653f\u7b56\u6807\u8bc6")
        @Pattern(regexp="^$|0[1-9]|1[0-8]")
        @JSONField(name="yhzcbs")
        private @Pattern(regexp="^$|0[1-9]|1[0-8]") String taxIncentivesType;

        ValidateResult validateData() {
            ValidateResult result = ValidateResult.success();
            result = BasicValidator.mergeValidateResult(result, this.isValidAmount());
            result = BasicValidator.mergeValidateResult(result, this.isValidTaxAmount());
            return result;
        }

        private ValidateResult isValidAmount() {
            BigDecimal quantity;
            if (StringUtils.isBlank((CharSequence)this.getUnitPrice()) || StringUtils.isBlank((CharSequence)this.getQuantity())) {
                return ValidateResult.success();
            }
            BigDecimal unitPrice = new BigDecimal(this.getUnitPrice());
            if (unitPrice.multiply(quantity = new BigDecimal(this.getQuantity())).subtract(this.getAmountWithoutTax()).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(0.01)) > 0) {
                return ValidateResult.fail("\u5355\u884c\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.01");
            }
            return ValidateResult.success();
        }

        private ValidateResult isValidTaxAmount() {
            if (this.getAmountWithoutTax().multiply(this.getTaxRate()).subtract(this.getTaxAmount()).abs().compareTo(BigDecimal.valueOf(0.06)) > 0) {
                return ValidateResult.fail("\u5355\u884c\u7a0e\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.06");
            }
            return ValidateResult.success();
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        public BigDecimal getDeduction() {
            return this.deduction;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        @Override
        public String getTaxIncentivesType() {
            return this.taxIncentivesType;
        }

        public void setAmountWithTax(BigDecimal amountWithTax) {
            this.amountWithTax = amountWithTax;
        }

        public void setDeduction(BigDecimal deduction) {
            this.deduction = deduction;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        @Override
        public void setTaxIncentivesType(String taxIncentivesType) {
            this.taxIncentivesType = taxIncentivesType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceDetail)) {
                return false;
            }
            InvoiceDetail other = (InvoiceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$amountWithTax = this.getAmountWithTax();
            BigDecimal other$amountWithTax = other.getAmountWithTax();
            if (this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax)) {
                return false;
            }
            BigDecimal this$deduction = this.getDeduction();
            BigDecimal other$deduction = other.getDeduction();
            if (this$deduction == null ? other$deduction != null : !((Object)this$deduction).equals(other$deduction)) {
                return false;
            }
            String this$discountType = this.getDiscountType();
            String other$discountType = other.getDiscountType();
            if (this$discountType == null ? other$discountType != null : !this$discountType.equals(other$discountType)) {
                return false;
            }
            String this$taxIncentivesType = this.getTaxIncentivesType();
            String other$taxIncentivesType = other.getTaxIncentivesType();
            return !(this$taxIncentivesType == null ? other$taxIncentivesType != null : !this$taxIncentivesType.equals(other$taxIncentivesType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceDetail;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $amountWithTax = this.getAmountWithTax();
            result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
            BigDecimal $deduction = this.getDeduction();
            result = result * 59 + ($deduction == null ? 43 : ((Object)$deduction).hashCode());
            String $discountType = this.getDiscountType();
            result = result * 59 + ($discountType == null ? 43 : $discountType.hashCode());
            String $taxIncentivesType = this.getTaxIncentivesType();
            result = result * 59 + ($taxIncentivesType == null ? 43 : $taxIncentivesType.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "InvoiceBaseValidator.InvoiceDetail(amountWithTax=" + this.getAmountWithTax() + ", deduction=" + this.getDeduction() + ", discountType=" + this.getDiscountType() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ")";
        }
    }
}

