/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.util.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ScriptAssert;

@ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.check.model.base.BaseDetail.isValidUnionInfo(_this)", message="\u6570\u91cf\u3001\u5355\u4ef7\u5fc5\u987b\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5")})
public class BaseDetail {
    @Alias(value="\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7")
    @Digits(integer=8, fraction=0)
    private @Digits(integer=8, fraction=0) Integer originalRowNum;
    @Alias(value="\u5e8f\u53f7")
    @NotNull
    @Digits(integer=8, fraction=0)
    private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
    @Alias(value="\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801")
    @NotEmpty
    @Length(max=19)
    private @NotEmpty @Length(max=19) String goodsTaxNo;
    @Alias(value="\u9879\u76ee\u540d\u79f0")
    @NotEmpty
    @Length(max=600)
    @Pattern(regexp="\\*.+?\\*.+")
    private @NotEmpty @Length(max=600) @Pattern(regexp="\\*.+?\\*.+") String itemName;
    @Alias(value="\u89c4\u683c\u578b\u53f7")
    @Length(max=150)
    private @Length(max=150) String specifications;
    @Alias(value="\u5355\u4f4d")
    @Length(max=300)
    private @Length(max=300) String unit;
    @Alias(value="\u5355\u4ef7")
    @Length(max=25)
    private @Length(max=25) String unitPrice;
    @Alias(value="\u6570\u91cf")
    @Length(max=25)
    private @Length(max=25) String quantity;
    @Alias(value="\u91d1\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
    @Alias(value="\u7a0e\u7387")
    @NotNull
    @Digits(integer=16, fraction=6)
    private @NotNull @Digits(integer=16, fraction=6) BigDecimal taxRate;
    @Alias(value="\u7a0e\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;
    private String taxIncentivesType;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseDetail that = (BaseDetail)o;
        if (!Objects.equals(this.originalRowNum, that.originalRowNum)) {
            return false;
        }
        if (!Objects.equals(this.rowNum, that.rowNum)) {
            return false;
        }
        if (!Objects.equals(this.goodsTaxNo, that.goodsTaxNo)) {
            return false;
        }
        if (!Objects.equals(this.itemName, that.itemName)) {
            return false;
        }
        if (!Objects.equals(this.unit, that.unit)) {
            return false;
        }
        if (NumberUtil.isNumber(this.unitPrice) && NumberUtil.isNumber(that.unitPrice) ? new BigDecimal(this.unitPrice).compareTo(new BigDecimal(that.unitPrice)) != 0 : !Objects.equals(this.unitPrice, that.unitPrice)) {
            return false;
        }
        if (NumberUtil.isNumber(this.quantity) && NumberUtil.isNumber(that.quantity) ? new BigDecimal(this.quantity).compareTo(new BigDecimal(that.quantity)) != 0 : !Objects.equals(this.quantity, that.quantity)) {
            return false;
        }
        if (!Objects.equals(this.specifications, that.specifications)) {
            return false;
        }
        if (this.amountWithoutTax.compareTo(that.amountWithoutTax) != 0) {
            return false;
        }
        if (this.taxRate.compareTo(that.taxRate) != 0) {
            return false;
        }
        return this.taxAmount.compareTo(that.taxAmount) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.originalRowNum, this.rowNum, this.goodsTaxNo, this.itemName, this.specifications, this.unit, this.unitPrice, this.quantity, this.amountWithoutTax, this.taxRate, this.taxAmount);
    }

    public static boolean isValidUnionInfo(BaseDetail detail) {
        if (detail.getUnitPrice() != null && detail.getUnitPrice().trim().length() > 0 || detail.getQuantity() != null && detail.getQuantity().trim().length() > 0) {
            return detail.getUnitPrice() != null && detail.getUnitPrice().trim().length() > 0 && detail.getQuantity() != null && detail.getQuantity().trim().length() > 0;
        }
        return true;
    }

    public String getItemShortName() {
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            return null;
        }
        List<String> split = Arrays.asList(StringUtils.split((String)this.itemName, (String)"*"));
        ArrayList<String> spmcsm = new ArrayList<String>(split);
        if (spmcsm.size() < 2 && !this.itemName.startsWith("*")) {
            return null;
        }
        return spmcsm.get(0);
    }

    public Integer getOriginalRowNum() {
        return this.originalRowNum;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public String getGoodsTaxNo() {
        return this.goodsTaxNo;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getSpecifications() {
        return this.specifications;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnitPrice() {
        return this.unitPrice;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public BigDecimal getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public String getTaxIncentivesType() {
        return this.taxIncentivesType;
    }

    public void setOriginalRowNum(Integer originalRowNum) {
        this.originalRowNum = originalRowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setSpecifications(String specifications) {
        this.specifications = specifications;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public void setTaxIncentivesType(String taxIncentivesType) {
        this.taxIncentivesType = taxIncentivesType;
    }

    public String toString() {
        return "BaseDetail(originalRowNum=" + this.getOriginalRowNum() + ", rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", itemName=" + this.getItemName() + ", specifications=" + this.getSpecifications() + ", unit=" + this.getUnit() + ", unitPrice=" + this.getUnitPrice() + ", quantity=" + this.getQuantity() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxRate=" + this.getTaxRate() + ", taxAmount=" + this.getTaxAmount() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ")";
    }
}

