/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.constant.TaxIncentivesTypeEnum;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Length;

public class SelfFarmProduceSalesBaseValidator {
    private List<SelfFarmProduceSalesDetail> selfFarmProduceSalesDetailList;
    private List<String> capabilityCodeList;

    public ValidateResult validate() {
        ValidateResult result = ValidateResult.success();
        if (this.selfFarmProduceSalesDetailList == null || this.selfFarmProduceSalesDetailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("12")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5f53\u524d\u5f00\u7968\u4f7f\u7528\u7684\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u80fd\u529b\u548c\u62e5\u6709\u7684\u4e50\u4f01\u5f00\u7968\u80fd\u529b\u4e0d\u5339\u914d\uff0c\u8bf7\u53bb\u9999\u8549\u8fd0\u7ef4\u9875\u9762\u914d\u7f6e\u76f8\u5173\u80fd\u529b"));
            return result;
        }
        for (SelfFarmProduceSalesDetail detail : this.selfFarmProduceSalesDetailList) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
        }
        return result;
    }

    public ValidateResult validateSelfFarmProduceSalesData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        List<String> selfFarmProduceSalesGoodsTaxNoList = provider.provideGoodsTaxNo();
        for (SelfFarmProduceSalesDetail selfFarmProduceSalesDetail : this.selfFarmProduceSalesDetailList) {
            if (!selfFarmProduceSalesGoodsTaxNoList.contains(selfFarmProduceSalesDetail.getGoodsTaxNo())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u65f6\uff0c\u53ea\u80fd\u4f7f\u7528\u7279\u5b9a\u8981\u7d20\u6807\u7b7e\u5f52\u7c7b\u4e3a\u201c11\uff08\u519c\u4ea7\u54c1\uff09\u201d \u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", selfFarmProduceSalesDetail.getRowNum())));
                return result;
            }
            if (!selfFarmProduceSalesDetail.getGoodsTaxNo().startsWith("101")) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u201c\u519c\u4ea7\u54c1\u201d\u7c7b\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801,\u201c\u519c\u4ea7\u54c1\u201d\u7c7b\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u662f\u4ee5\u201c101\u201d\u5f00\u5934\u7684\u5546\u54c1\u7f16\u7801\u3002", selfFarmProduceSalesDetail.getRowNum())));
                return result;
            }
            if (selfFarmProduceSalesDetail.getTaxIncentivesType() != TaxIncentivesTypeEnum.DUTY_FREE) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\uff1a\u5fc5\u987b\u4f7f\u7528\u201c\u514d\u7a0e\u201d\u4f18\u60e0\u653f\u7b56", selfFarmProduceSalesDetail.getRowNum())));
                return result;
            }
            if (selfFarmProduceSalesDetail.getTaxRate().compareTo(BigDecimal.ZERO) != 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\uff1a\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u56fa\u5b9a\u4e3a0", selfFarmProduceSalesDetail.getRowNum())));
                return result;
            }
            if (selfFarmProduceSalesDetail.getTaxAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\uff1a\u589e\u503c\u7a0e\u7a0e\u989d\u56fa\u5b9a\u4e3a0", selfFarmProduceSalesDetail.getRowNum())));
            return result;
        }
        return result;
    }

    public List<SelfFarmProduceSalesDetail> getSelfFarmProduceSalesDetailList() {
        return this.selfFarmProduceSalesDetailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public void setSelfFarmProduceSalesDetailList(List<SelfFarmProduceSalesDetail> selfFarmProduceSalesDetailList) {
        this.selfFarmProduceSalesDetailList = selfFarmProduceSalesDetailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelfFarmProduceSalesBaseValidator)) {
            return false;
        }
        SelfFarmProduceSalesBaseValidator other = (SelfFarmProduceSalesBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SelfFarmProduceSalesDetail> this$selfFarmProduceSalesDetailList = this.getSelfFarmProduceSalesDetailList();
        List<SelfFarmProduceSalesDetail> other$selfFarmProduceSalesDetailList = other.getSelfFarmProduceSalesDetailList();
        if (this$selfFarmProduceSalesDetailList == null ? other$selfFarmProduceSalesDetailList != null : !((Object)this$selfFarmProduceSalesDetailList).equals(other$selfFarmProduceSalesDetailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        return !(this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelfFarmProduceSalesBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SelfFarmProduceSalesDetail> $selfFarmProduceSalesDetailList = this.getSelfFarmProduceSalesDetailList();
        result = result * 59 + ($selfFarmProduceSalesDetailList == null ? 43 : ((Object)$selfFarmProduceSalesDetailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        return result;
    }

    public String toString() {
        return "SelfFarmProduceSalesBaseValidator(selfFarmProduceSalesDetailList=" + this.getSelfFarmProduceSalesDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ")";
    }

    public static class SelfFarmProduceSalesDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;
        private TaxIncentivesTypeEnum taxIncentivesType;
        @Alias(value="\u660e\u7ec6\u7a0e\u7387")
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxRate;
        @Alias(value="\u660e\u7ec6\u7a0e\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public TaxIncentivesTypeEnum getTaxIncentivesType() {
            return this.taxIncentivesType;
        }

        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public void setTaxIncentivesType(TaxIncentivesTypeEnum taxIncentivesType) {
            this.taxIncentivesType = taxIncentivesType;
        }

        public void setTaxRate(BigDecimal taxRate) {
            this.taxRate = taxRate;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelfFarmProduceSalesDetail)) {
                return false;
            }
            SelfFarmProduceSalesDetail other = (SelfFarmProduceSalesDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
                return false;
            }
            TaxIncentivesTypeEnum this$taxIncentivesType = this.getTaxIncentivesType();
            TaxIncentivesTypeEnum other$taxIncentivesType = other.getTaxIncentivesType();
            if (this$taxIncentivesType == null ? other$taxIncentivesType != null : !((Object)((Object)this$taxIncentivesType)).equals((Object)other$taxIncentivesType)) {
                return false;
            }
            BigDecimal this$taxRate = this.getTaxRate();
            BigDecimal other$taxRate = other.getTaxRate();
            if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
                return false;
            }
            BigDecimal this$taxAmount = this.getTaxAmount();
            BigDecimal other$taxAmount = other.getTaxAmount();
            return !(this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelfFarmProduceSalesDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            TaxIncentivesTypeEnum $taxIncentivesType = this.getTaxIncentivesType();
            result = result * 59 + ($taxIncentivesType == null ? 43 : ((Object)((Object)$taxIncentivesType)).hashCode());
            BigDecimal $taxRate = this.getTaxRate();
            result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
            BigDecimal $taxAmount = this.getTaxAmount();
            result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
            return result;
        }

        public String toString() {
            return "SelfFarmProduceSalesBaseValidator.SelfFarmProduceSalesDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ", taxRate=" + this.getTaxRate() + ", taxAmount=" + this.getTaxAmount() + ")";
        }
    }
}

