/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.constant.AreaUnitEnum;
import com.xforceplus.taxware.chestnut.check.model.constant.TaxIncentivesTypeEnum;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class RealEstateLeaseBaseValidator {
    private static final List<String> realEstatePlaceKeyWord = Arrays.asList("\u8857", "\u8def", "\u6751", "\u4e61", "\u9547", "\u9053", "\u5df7", "\u53f7");
    @Alias(value="\u4e0d\u52a8\u4ea7\u79df\u8d41\u660e\u7ec6\u5217\u8868")
    private List<RealEstateLeaseDetail> realEstateLeaseDetails;
    private RealEstateLeaseInfo realEstateLeaseInfo;
    private List<String> capabilityCodeList;

    public ValidateResult validate() {
        ValidateResult result = BasicValidator.validate(this);
        if (this.realEstateLeaseDetails == null || this.realEstateLeaseDetails.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u79df\u8d41\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateLeaseDetails.size() != 1) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u79df\u8d41\u53d1\u7968\u660e\u7ec6\u53ea\u80fd\u6709\u4e00\u884c"));
            return result;
        }
        if (this.realEstateLeaseInfo == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u79df\u8d41\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateLeaseInfo.getCrossCitySign() == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateLeaseInfo.getAreaUnit() == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u9762\u79ef\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateLeaseInfo.getLeaseTermStart() == null || this.realEstateLeaseInfo.getLeaseTermEnd() == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u683c\u5f0f\u5e94\u4e3ayyyyMMdd"));
            return result;
        }
        if (StringUtils.isBlank((CharSequence)this.realEstateLeaseInfo.getRealEstatePlace()) || realEstatePlaceKeyWord.stream().noneMatch(x -> this.realEstateLeaseInfo.getRealEstatePlace().contains((CharSequence)x))) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u5730\u5740\u5fc5\u987b\u5305\u542b\u8857\u3001\u8def\u3001\u6751\u3001\u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u7b49\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd\u3002"));
            return result;
        }
        if (this.realEstateLeaseInfo.getRealEstatePlace().length() > 80) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u79df\u8d41\u53d1\u7968\u5f00\u5177\uff1a\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u8be6\u7ec6\u5730\u5740\uff09\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc780"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("06")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5f53\u524d\u5f00\u7968\u4f7f\u7528\u7684\u4e0d\u52a8\u4ea7\u79df\u8d41\u80fd\u529b\u548c\u62e5\u6709\u7684\u4e50\u4f01\u5f00\u7968\u80fd\u529b\u4e0d\u5339\u914d\uff0c\u8bf7\u53bb\u9999\u8549\u8fd0\u7ef4\u9875\u9762\u914d\u7f6e\u76f8\u5173\u80fd\u529b"));
            return result;
        }
        for (RealEstateLeaseDetail detail : this.realEstateLeaseDetails) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
        }
        return result;
    }

    public ValidateResult validateRealEstateLeaseData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        RealEstateLeaseDetail realEstateLeaseDetail = this.getRealEstateLeaseDetails().get(0);
        List<String> realEstateLeaseGoodTaxNoList = provider.provideGoodsTaxNo();
        if (!realEstateLeaseGoodTaxNoList.contains(realEstateLeaseDetail.getGoodsTaxNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e2d\u4e0d\u52a8\u4ea7\u79df\u8d41\u7c7b\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5"));
            return result;
        }
        if (Objects.equals(realEstateLeaseDetail.getGoodsTaxNo(), "3040502020102000000")) {
            if (realEstateLeaseDetail.getTaxIncentivesType() != TaxIncentivesTypeEnum.FIVE_PERCENT_SIMPLE_EXPROPRIATION_REDUCE_ONE_POINT_FIVE_PERCENT) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e2a\u4f53\u5de5\u5546\u6237\u6216\u81ea\u7136\u4eba\u5728\u4f7f\u7528\u201c3040502020102000000\u4e2a\u4eba\u51fa\u79df\u4f4f\u623f\u201d\u5f00\u5177\u4e0d\u52a8\u4ea7\u79df\u8d41\u53d1\u7968\u65f6\uff0c\u53ea\u80fd\u6309\u71675%\u51cf\u63091.5%\u8ba1\u7b97\u5e94\u7eb3\u7a0e\u989d"));
                return result;
            }
            BigDecimal amountWithTax = realEstateLeaseDetail.getAmountWithTax();
            BigDecimal onePlusFivePercent = new BigDecimal("1.05");
            BigDecimal onePointFivePercent = new BigDecimal("0.015");
            BigDecimal calculateTaxAmount = amountWithTax.multiply(onePointFivePercent).divide(onePlusFivePercent, 4);
            BigDecimal calculateAmountWithoutTax = amountWithTax.subtract(calculateTaxAmount);
            BigDecimal judgeNum = new BigDecimal("0.01");
            if (realEstateLeaseDetail.getTaxAmount().subtract(calculateTaxAmount).abs().compareTo(judgeNum) > 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5e94\u7eb3\u7a0e\u989d\u8ba1\u7b97\u65b9\u5f0f\u4e3a\uff1a\u7a0e\u989d=\u542b\u7a0e\u9500\u552e\u989d/\uff081+5%\uff09*1.5%\uff0c\u8bf7\u68c0\u67e5\u7a0e\u989d\u662f\u5426\u6b63\u786e"));
                return result;
            }
            if (realEstateLeaseDetail.getAmountWithoutTax().subtract(calculateAmountWithoutTax).abs().compareTo(judgeNum) > 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5e94\u7eb3\u7a0e\u989d\u8ba1\u7b97\u65b9\u5f0f\u4e3a\uff1a\u7a0e\u989d=\u542b\u7a0e\u9500\u552e\u989d/\uff081+5%\uff09*1.5%\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d=\u542b\u7a0e\u9500\u552e\u989d-\u7a0e\u989d\u3002\u8bf7\u68c0\u67e5\u4e0d\u542b\u7a0e\u91d1\u989d\u662f\u5426\u6b63\u786e"));
                return result;
            }
        }
        return result;
    }

    public List<RealEstateLeaseDetail> getRealEstateLeaseDetails() {
        return this.realEstateLeaseDetails;
    }

    public RealEstateLeaseInfo getRealEstateLeaseInfo() {
        return this.realEstateLeaseInfo;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public void setRealEstateLeaseDetails(List<RealEstateLeaseDetail> realEstateLeaseDetails) {
        this.realEstateLeaseDetails = realEstateLeaseDetails;
    }

    public void setRealEstateLeaseInfo(RealEstateLeaseInfo realEstateLeaseInfo) {
        this.realEstateLeaseInfo = realEstateLeaseInfo;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealEstateLeaseBaseValidator)) {
            return false;
        }
        RealEstateLeaseBaseValidator other = (RealEstateLeaseBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RealEstateLeaseDetail> this$realEstateLeaseDetails = this.getRealEstateLeaseDetails();
        List<RealEstateLeaseDetail> other$realEstateLeaseDetails = other.getRealEstateLeaseDetails();
        if (this$realEstateLeaseDetails == null ? other$realEstateLeaseDetails != null : !((Object)this$realEstateLeaseDetails).equals(other$realEstateLeaseDetails)) {
            return false;
        }
        RealEstateLeaseInfo this$realEstateLeaseInfo = this.getRealEstateLeaseInfo();
        RealEstateLeaseInfo other$realEstateLeaseInfo = other.getRealEstateLeaseInfo();
        if (this$realEstateLeaseInfo == null ? other$realEstateLeaseInfo != null : !((Object)this$realEstateLeaseInfo).equals(other$realEstateLeaseInfo)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        return !(this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RealEstateLeaseBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RealEstateLeaseDetail> $realEstateLeaseDetails = this.getRealEstateLeaseDetails();
        result = result * 59 + ($realEstateLeaseDetails == null ? 43 : ((Object)$realEstateLeaseDetails).hashCode());
        RealEstateLeaseInfo $realEstateLeaseInfo = this.getRealEstateLeaseInfo();
        result = result * 59 + ($realEstateLeaseInfo == null ? 43 : ((Object)$realEstateLeaseInfo).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        return result;
    }

    public String toString() {
        return "RealEstateLeaseBaseValidator(realEstateLeaseDetails=" + this.getRealEstateLeaseDetails() + ", realEstateLeaseInfo=" + this.getRealEstateLeaseInfo() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ")";
    }

    public static class RealEstateLeaseDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u4e0d\u52a8\u4ea7\u79df\u8d41\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;
        private TaxIncentivesTypeEnum taxIncentivesType;
        @Alias(value="\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
        @Alias(value="\u7a0e\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;
        @Alias(value="\u542b\u7a0e\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="hsje")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public TaxIncentivesTypeEnum getTaxIncentivesType() {
            return this.taxIncentivesType;
        }

        public BigDecimal getAmountWithoutTax() {
            return this.amountWithoutTax;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public void setTaxIncentivesType(TaxIncentivesTypeEnum taxIncentivesType) {
            this.taxIncentivesType = taxIncentivesType;
        }

        public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
            this.amountWithoutTax = amountWithoutTax;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public void setAmountWithTax(BigDecimal amountWithTax) {
            this.amountWithTax = amountWithTax;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RealEstateLeaseDetail)) {
                return false;
            }
            RealEstateLeaseDetail other = (RealEstateLeaseDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
                return false;
            }
            TaxIncentivesTypeEnum this$taxIncentivesType = this.getTaxIncentivesType();
            TaxIncentivesTypeEnum other$taxIncentivesType = other.getTaxIncentivesType();
            if (this$taxIncentivesType == null ? other$taxIncentivesType != null : !((Object)((Object)this$taxIncentivesType)).equals((Object)other$taxIncentivesType)) {
                return false;
            }
            BigDecimal this$amountWithoutTax = this.getAmountWithoutTax();
            BigDecimal other$amountWithoutTax = other.getAmountWithoutTax();
            if (this$amountWithoutTax == null ? other$amountWithoutTax != null : !((Object)this$amountWithoutTax).equals(other$amountWithoutTax)) {
                return false;
            }
            BigDecimal this$taxAmount = this.getTaxAmount();
            BigDecimal other$taxAmount = other.getTaxAmount();
            if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                return false;
            }
            BigDecimal this$amountWithTax = this.getAmountWithTax();
            BigDecimal other$amountWithTax = other.getAmountWithTax();
            return !(this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RealEstateLeaseDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            TaxIncentivesTypeEnum $taxIncentivesType = this.getTaxIncentivesType();
            result = result * 59 + ($taxIncentivesType == null ? 43 : ((Object)((Object)$taxIncentivesType)).hashCode());
            BigDecimal $amountWithoutTax = this.getAmountWithoutTax();
            result = result * 59 + ($amountWithoutTax == null ? 43 : ((Object)$amountWithoutTax).hashCode());
            BigDecimal $taxAmount = this.getTaxAmount();
            result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
            BigDecimal $amountWithTax = this.getAmountWithTax();
            result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
            return result;
        }

        public String toString() {
            return "RealEstateLeaseBaseValidator.RealEstateLeaseDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxAmount=" + this.getTaxAmount() + ", amountWithTax=" + this.getAmountWithTax() + ")";
        }
    }

    public static class RealEstateLeaseInfo {
        @Alias(value="\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7801")
        @Length(max=40)
        private @Length(max=40) String realEstateNo;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u7701\u4efd")
        private String realEstateProvince;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u5e02")
        private String realEstateCity;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u8be6\u7ec6\u5730\u5740")
        private String realEstatePlace;
        private Date leaseTermStart;
        private Date leaseTermEnd;
        private Boolean crossCitySign;
        private AreaUnitEnum areaUnit;

        public String getRealEstateNo() {
            return this.realEstateNo;
        }

        public String getRealEstateProvince() {
            return this.realEstateProvince;
        }

        public String getRealEstateCity() {
            return this.realEstateCity;
        }

        public String getRealEstatePlace() {
            return this.realEstatePlace;
        }

        public Date getLeaseTermStart() {
            return this.leaseTermStart;
        }

        public Date getLeaseTermEnd() {
            return this.leaseTermEnd;
        }

        public Boolean getCrossCitySign() {
            return this.crossCitySign;
        }

        public AreaUnitEnum getAreaUnit() {
            return this.areaUnit;
        }

        public void setRealEstateNo(String realEstateNo) {
            this.realEstateNo = realEstateNo;
        }

        public void setRealEstateProvince(String realEstateProvince) {
            this.realEstateProvince = realEstateProvince;
        }

        public void setRealEstateCity(String realEstateCity) {
            this.realEstateCity = realEstateCity;
        }

        public void setRealEstatePlace(String realEstatePlace) {
            this.realEstatePlace = realEstatePlace;
        }

        public void setLeaseTermStart(Date leaseTermStart) {
            this.leaseTermStart = leaseTermStart;
        }

        public void setLeaseTermEnd(Date leaseTermEnd) {
            this.leaseTermEnd = leaseTermEnd;
        }

        public void setCrossCitySign(Boolean crossCitySign) {
            this.crossCitySign = crossCitySign;
        }

        public void setAreaUnit(AreaUnitEnum areaUnit) {
            this.areaUnit = areaUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RealEstateLeaseInfo)) {
                return false;
            }
            RealEstateLeaseInfo other = (RealEstateLeaseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$realEstateNo = this.getRealEstateNo();
            String other$realEstateNo = other.getRealEstateNo();
            if (this$realEstateNo == null ? other$realEstateNo != null : !this$realEstateNo.equals(other$realEstateNo)) {
                return false;
            }
            String this$realEstateProvince = this.getRealEstateProvince();
            String other$realEstateProvince = other.getRealEstateProvince();
            if (this$realEstateProvince == null ? other$realEstateProvince != null : !this$realEstateProvince.equals(other$realEstateProvince)) {
                return false;
            }
            String this$realEstateCity = this.getRealEstateCity();
            String other$realEstateCity = other.getRealEstateCity();
            if (this$realEstateCity == null ? other$realEstateCity != null : !this$realEstateCity.equals(other$realEstateCity)) {
                return false;
            }
            String this$realEstatePlace = this.getRealEstatePlace();
            String other$realEstatePlace = other.getRealEstatePlace();
            if (this$realEstatePlace == null ? other$realEstatePlace != null : !this$realEstatePlace.equals(other$realEstatePlace)) {
                return false;
            }
            Date this$leaseTermStart = this.getLeaseTermStart();
            Date other$leaseTermStart = other.getLeaseTermStart();
            if (this$leaseTermStart == null ? other$leaseTermStart != null : !((Object)this$leaseTermStart).equals(other$leaseTermStart)) {
                return false;
            }
            Date this$leaseTermEnd = this.getLeaseTermEnd();
            Date other$leaseTermEnd = other.getLeaseTermEnd();
            if (this$leaseTermEnd == null ? other$leaseTermEnd != null : !((Object)this$leaseTermEnd).equals(other$leaseTermEnd)) {
                return false;
            }
            Boolean this$crossCitySign = this.getCrossCitySign();
            Boolean other$crossCitySign = other.getCrossCitySign();
            if (this$crossCitySign == null ? other$crossCitySign != null : !((Object)this$crossCitySign).equals(other$crossCitySign)) {
                return false;
            }
            AreaUnitEnum this$areaUnit = this.getAreaUnit();
            AreaUnitEnum other$areaUnit = other.getAreaUnit();
            return !(this$areaUnit == null ? other$areaUnit != null : !((Object)((Object)this$areaUnit)).equals((Object)other$areaUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RealEstateLeaseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $realEstateNo = this.getRealEstateNo();
            result = result * 59 + ($realEstateNo == null ? 43 : $realEstateNo.hashCode());
            String $realEstateProvince = this.getRealEstateProvince();
            result = result * 59 + ($realEstateProvince == null ? 43 : $realEstateProvince.hashCode());
            String $realEstateCity = this.getRealEstateCity();
            result = result * 59 + ($realEstateCity == null ? 43 : $realEstateCity.hashCode());
            String $realEstatePlace = this.getRealEstatePlace();
            result = result * 59 + ($realEstatePlace == null ? 43 : $realEstatePlace.hashCode());
            Date $leaseTermStart = this.getLeaseTermStart();
            result = result * 59 + ($leaseTermStart == null ? 43 : ((Object)$leaseTermStart).hashCode());
            Date $leaseTermEnd = this.getLeaseTermEnd();
            result = result * 59 + ($leaseTermEnd == null ? 43 : ((Object)$leaseTermEnd).hashCode());
            Boolean $crossCitySign = this.getCrossCitySign();
            result = result * 59 + ($crossCitySign == null ? 43 : ((Object)$crossCitySign).hashCode());
            AreaUnitEnum $areaUnit = this.getAreaUnit();
            result = result * 59 + ($areaUnit == null ? 43 : ((Object)((Object)$areaUnit)).hashCode());
            return result;
        }

        public String toString() {
            return "RealEstateLeaseBaseValidator.RealEstateLeaseInfo(realEstateNo=" + this.getRealEstateNo() + ", realEstateProvince=" + this.getRealEstateProvince() + ", realEstateCity=" + this.getRealEstateCity() + ", realEstatePlace=" + this.getRealEstatePlace() + ", leaseTermStart=" + this.getLeaseTermStart() + ", leaseTermEnd=" + this.getLeaseTermEnd() + ", crossCitySign=" + this.getCrossCitySign() + ", areaUnit=" + this.getAreaUnit() + ")";
        }
    }
}

