package com.xforceplus.taxware.chestnut.check.model.constant;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;

/**
 * @author Thj
 * @createdAt: 2024/3/1 14:38
 * @Description:
 */
public enum TransportationTypeEnum {
    TIELU("01", "铁路运输"),
    GONGLU("02", "公路运输"),
    SHUILU("03", "水路运输"),
    HANGKONG("04", "航空运输"),
    GUANDAO("05", "管道运输");

    private String code;
    private String name;

    TransportationTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

    public static TransportationTypeEnum fromCode(@NotNull String code) {

        return Arrays.stream(TransportationTypeEnum.values())
                .filter(transportationTypeEnum -> code.equals(transportationTypeEnum.toCode()))
                .findAny().orElse(null);
    }
}
