package com.xforceplus.taxware.chestnut.check.model.validator.taxpayer;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxpayerRiskInfo;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxpayerRiskFlagEnum;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxpayerRiskTypeEnum;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxpayerWarningLevelEnum;

/**
 * @Auther lv
 * @Date 2023/2/13
 * @Descrption 纳税人风险信息校验：
 */
public class TaxpayerRiskValidator {

    /**
     * 	未查询到纳税人风险信息，本地无纳税人风险信息。
     * 	纳税人风险信息中-风险纳税人类型“授信类别”为“Ⅰ类”。
     * 	纳税人风险信息中“纳税人预警级别”为“红色预警”。
     * 	纳税人风险信息中“风险纳税人标志”为“Y（风险纳税人）”。
     */
    public static void validate(TaxpayerRiskInfo taxpayerRiskInfo) {

        if(taxpayerRiskInfo == null){
            throw new TXWR000004Exception("未查询到纳税人风险信息，禁止开票");
        }

        /**
         * 风险纳税人类型（非必须）
         * 空：非风险纳税人
         * 01：Ⅰ类（高风险）纳税人
         * 02：Ⅱ类（中风险）纳税人
         * 03：Ⅲ类（低风险）纳税人
         * 04：Ⅳ类（无风险）纳税人
         */
        String taxpayerRiskType = taxpayerRiskInfo.getTaxpayerRiskType();
        if(TaxpayerRiskTypeEnum.TAXPAYER_RISK_TYPE_01.getStatus().equals(taxpayerRiskType)){
            throw new TXWR000004Exception("该纳税人为Ⅰ类（高风险）纳税人，禁止开票");
        }

        /**
         * 纳税人预警级别（非必须）
         * 空：无预警
         * 01：红色预警
         * 02：黄色预警
         * 03：蓝色预警
         */
         String taxpayerWarningLevel = taxpayerRiskInfo.getTaxpayerWarningLevel();
        if(TaxpayerWarningLevelEnum.TAXPAYER_WARNING_LEVEL_01.getStatus().equals(taxpayerWarningLevel)){
            throw new TXWR000004Exception("该纳税人预警级别为红色预警，禁止开票");
        }

        /**
         * 风险纳税人标志
         * Y：风险纳税人
         * N：正常纳税人
         */
         String taxpayerRiskFlag = taxpayerRiskInfo.getTaxpayerRiskFlag();
        if(!TaxpayerRiskFlagEnum.TAXPAYER_RISK_FLAG_N.getStatus().equals(taxpayerRiskFlag)){
            throw new TXWR000004Exception("该纳税人为风险纳税人，禁止开票");
        }
    }
}
