/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Length;

public class FarmProducePurchaseBaseValidator {
    private FarmProducePurchaseInfo farmProducePurchaseInfo;
    private List<FarmProducePurchaseDetail> farmProducePurchaseDetailList;
    private List<String> capabilityCodeList;

    public ValidateResult validate() {
        ValidateResult result = ValidateResult.success();
        if (this.farmProducePurchaseDetailList == null || this.farmProducePurchaseDetailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u519c\u4ea7\u54c1\u6536\u8d2d\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.farmProducePurchaseInfo == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u519c\u4ea7\u54c1\u6536\u8d2d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (!Objects.equals(this.farmProducePurchaseInfo.getInvoiceType(), "02")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\uff0c\u53ea\u5141\u8bb8\u5f00\u5177\u5168\u7535\u7535\u5b50\u666e\u901a\u53d1\u7968"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("16")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5f53\u524d\u5f00\u7968\u4f7f\u7528\u7684\u519c\u4ea7\u54c1\u6536\u8d2d\u80fd\u529b\u548c\u62e5\u6709\u7684\u4e50\u4f01\u5f00\u7968\u80fd\u529b\u4e0d\u5339\u914d\uff0c\u8bf7\u53bb\u9999\u8549\u8fd0\u7ef4\u9875\u9762\u914d\u7f6e\u76f8\u5173\u80fd\u529b"));
            return result;
        }
        return result;
    }

    public ValidateResult validateFarmProducePurchaseData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        List<String> farmProducePurchaseGoodsTaxNoList = provider.provideGoodsTaxNo();
        for (FarmProducePurchaseDetail farmProducePurchaseDetail : this.farmProducePurchaseDetailList) {
            if (!farmProducePurchaseGoodsTaxNoList.contains(farmProducePurchaseDetail.getGoodsTaxNo())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e2d\u519c\u4ea7\u54c1\u6536\u8d2d\u7c7b\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", farmProducePurchaseDetail.getRowNum())));
                return result;
            }
            if (farmProducePurchaseDetail.getGoodsTaxNo().startsWith("101")) continue;
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u201c\u519c\u4ea7\u54c1\u201d\u7c7b\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801,\u201c\u519c\u4ea7\u54c1\u201d\u7c7b\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u662f\u4ee5\u201c101\u201d\u5f00\u5934\u7684\u5546\u54c1\u7f16\u7801\u3002", farmProducePurchaseDetail.getRowNum())));
            return result;
        }
        return result;
    }

    public FarmProducePurchaseInfo getFarmProducePurchaseInfo() {
        return this.farmProducePurchaseInfo;
    }

    public List<FarmProducePurchaseDetail> getFarmProducePurchaseDetailList() {
        return this.farmProducePurchaseDetailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public void setFarmProducePurchaseInfo(FarmProducePurchaseInfo farmProducePurchaseInfo) {
        this.farmProducePurchaseInfo = farmProducePurchaseInfo;
    }

    public void setFarmProducePurchaseDetailList(List<FarmProducePurchaseDetail> farmProducePurchaseDetailList) {
        this.farmProducePurchaseDetailList = farmProducePurchaseDetailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FarmProducePurchaseBaseValidator)) {
            return false;
        }
        FarmProducePurchaseBaseValidator other = (FarmProducePurchaseBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FarmProducePurchaseInfo this$farmProducePurchaseInfo = this.getFarmProducePurchaseInfo();
        FarmProducePurchaseInfo other$farmProducePurchaseInfo = other.getFarmProducePurchaseInfo();
        if (this$farmProducePurchaseInfo == null ? other$farmProducePurchaseInfo != null : !((Object)this$farmProducePurchaseInfo).equals(other$farmProducePurchaseInfo)) {
            return false;
        }
        List<FarmProducePurchaseDetail> this$farmProducePurchaseDetailList = this.getFarmProducePurchaseDetailList();
        List<FarmProducePurchaseDetail> other$farmProducePurchaseDetailList = other.getFarmProducePurchaseDetailList();
        if (this$farmProducePurchaseDetailList == null ? other$farmProducePurchaseDetailList != null : !((Object)this$farmProducePurchaseDetailList).equals(other$farmProducePurchaseDetailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        return !(this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FarmProducePurchaseBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FarmProducePurchaseInfo $farmProducePurchaseInfo = this.getFarmProducePurchaseInfo();
        result = result * 59 + ($farmProducePurchaseInfo == null ? 43 : ((Object)$farmProducePurchaseInfo).hashCode());
        List<FarmProducePurchaseDetail> $farmProducePurchaseDetailList = this.getFarmProducePurchaseDetailList();
        result = result * 59 + ($farmProducePurchaseDetailList == null ? 43 : ((Object)$farmProducePurchaseDetailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        return result;
    }

    public String toString() {
        return "FarmProducePurchaseBaseValidator(farmProducePurchaseInfo=" + this.getFarmProducePurchaseInfo() + ", farmProducePurchaseDetailList=" + this.getFarmProducePurchaseDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ")";
    }

    public static class FarmProducePurchaseDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u519c\u4ea7\u54c1\u6536\u8d2d\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FarmProducePurchaseDetail)) {
                return false;
            }
            FarmProducePurchaseDetail other = (FarmProducePurchaseDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            return !(this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FarmProducePurchaseDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            return result;
        }

        public String toString() {
            return "FarmProducePurchaseBaseValidator.FarmProducePurchaseDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ")";
        }
    }

    public static class FarmProducePurchaseInfo {
        private String sellerTaxCode;
        private String purchaserTaxCode;
        private String invoiceType;

        public String getSellerTaxCode() {
            return this.sellerTaxCode;
        }

        public String getPurchaserTaxCode() {
            return this.purchaserTaxCode;
        }

        public String getInvoiceType() {
            return this.invoiceType;
        }

        public void setSellerTaxCode(String sellerTaxCode) {
            this.sellerTaxCode = sellerTaxCode;
        }

        public void setPurchaserTaxCode(String purchaserTaxCode) {
            this.purchaserTaxCode = purchaserTaxCode;
        }

        public void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FarmProducePurchaseInfo)) {
                return false;
            }
            FarmProducePurchaseInfo other = (FarmProducePurchaseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sellerTaxCode = this.getSellerTaxCode();
            String other$sellerTaxCode = other.getSellerTaxCode();
            if (this$sellerTaxCode == null ? other$sellerTaxCode != null : !this$sellerTaxCode.equals(other$sellerTaxCode)) {
                return false;
            }
            String this$purchaserTaxCode = this.getPurchaserTaxCode();
            String other$purchaserTaxCode = other.getPurchaserTaxCode();
            if (this$purchaserTaxCode == null ? other$purchaserTaxCode != null : !this$purchaserTaxCode.equals(other$purchaserTaxCode)) {
                return false;
            }
            String this$invoiceType = this.getInvoiceType();
            String other$invoiceType = other.getInvoiceType();
            return !(this$invoiceType == null ? other$invoiceType != null : !this$invoiceType.equals(other$invoiceType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FarmProducePurchaseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sellerTaxCode = this.getSellerTaxCode();
            result = result * 59 + ($sellerTaxCode == null ? 43 : $sellerTaxCode.hashCode());
            String $purchaserTaxCode = this.getPurchaserTaxCode();
            result = result * 59 + ($purchaserTaxCode == null ? 43 : $purchaserTaxCode.hashCode());
            String $invoiceType = this.getInvoiceType();
            result = result * 59 + ($invoiceType == null ? 43 : $invoiceType.hashCode());
            return result;
        }

        public String toString() {
            return "FarmProducePurchaseBaseValidator.FarmProducePurchaseInfo(sellerTaxCode=" + this.getSellerTaxCode() + ", purchaserTaxCode=" + this.getPurchaserTaxCode() + ", invoiceType=" + this.getInvoiceType() + ")";
        }
    }
}

