/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.architecture.g1.core.utils.ExceptionUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000001Exception;
import com.xforceplus.taxware.chestnut.check.model.base.OilTaxCode;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.CPYGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.CapabilityCodeEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class CPYBaseValidator {
    @Alias(value="\u6210\u54c1\u6cb9\u660e\u7ec6\u5217\u8868")
    private List<CPYDetail> cpyDetailList;
    private List<String> capabilityCodeList;
    private Integer invoiceNumber;

    public ValidateResult validate() {
        ValidateResult result = BasicValidator.validate(this);
        if (this.cpyDetailList == null || this.cpyDetailList.size() == 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6210\u54c1\u6cb9\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.cpyDetailList.size() > 2000) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6210\u54c1\u6cb9\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u5927\u4e8e2000\u884c"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("01")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8bf7\u524d\u5f80\u7535\u5b50\u7a0e\u5c40\u201c\u4e50\u4f01\u6570\u5b57\u5f00\u653e\u5e73\u53f0\u201d\u68c0\u67e5\u6240\u4f7f\u7528\u7684[%s]\u662f\u5426\u5df2\u88ab\u6388\u6743\u9080\u8bf7", CapabilityCodeEnum.fromCode((String)"01").toDesc())));
            return result;
        }
        for (CPYDetail detail : this.cpyDetailList) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
        }
        return result;
    }

    public ValidateResult validateCpyData(CPYGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        List<CPYDetail> cpyDetailList = this.getCpyDetailList();
        List goodsTaxNoList = cpyDetailList.stream().map(CPYDetail::getGoodsTaxNo).distinct().collect(Collectors.toList());
        if (goodsTaxNoList.contains("1070101020100000000") || goodsTaxNoList.contains("1070101040200000000") || goodsTaxNoList.contains("1070101050200000000")) {
            if (cpyDetailList.size() > 1) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6210\u54c1\u6cb9\u7eb3\u7a0e\u4eba\u5f00\u5177\u7a0e\u7f16\u660e\u7ec6\u542b\u6709\u4e0d\u5f97\u76f8\u4e92\u6df7\u5f00\u7684\u7a0e\u7f16\uff0c\u8bf7\u68c0\u67e5\u3002"));
                return result;
            }
            if (this.invoiceNumber > 1) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u672c\u6b21\u6279\u91cf\u5f00\u5177\u7684\u6210\u54c1\u6cb9\u53d1\u7968\u660e\u7ec6\u4e2d\u542b\u6709\u4e0d\u5f97\u4e0e\u5176\u4ed6\u53d1\u7968\u6df7\u5f00\u7684\u7a0e\u7f16\uff0c\u8bf7\u68c0\u67e5\u3002"));
                return result;
            }
        }
        if (provider == null || provider.provide() == null) {
            return result;
        }
        List<OilTaxCode> oilTaxCodeList = provider.provide();
        List oilGoodsTaxNoList = oilTaxCodeList.stream().map(OilTaxCode::getGoodsTaxNo).distinct().collect(Collectors.toList());
        try {
            cpyDetailList.forEach(cpyDetail -> {
                if (!oilGoodsTaxNoList.contains(cpyDetail.getGoodsTaxNo())) {
                    throw new TXWR000001Exception(String.format("\u7b2c%d\u884c\u660e\u7ec6,\u542b\u6709\u975e\u5df2\u6388\u6743\u7684\u6210\u54c1\u6cb9\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", cpyDetail.getRowNum()));
                }
                OilTaxCode oilTaxNo = oilTaxCodeList.stream().filter(oilGoodsTaxNo -> StringUtils.equals((CharSequence)oilGoodsTaxNo.getGoodsTaxNo(), (CharSequence)cpyDetail.getGoodsTaxNo())).findAny().orElseThrow(() -> new TXWR000001Exception("\u542b\u6709\u975e\u5df2\u6388\u6743\u7684\u6210\u54c1\u6cb9\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5"));
                if (StringUtils.equals((CharSequence)oilTaxNo.getLevyItemName(), (CharSequence)"\u71c3\u6599\u6cb9") && !StringUtils.equals((CharSequence)cpyDetail.getUnit(), (CharSequence)"\u5428") && !StringUtils.equals((CharSequence)cpyDetail.getUnit(), (CharSequence)"\u5347")) {
                    throw new TXWR000001Exception(String.format("\u7b2c%d\u884c\u660e\u7ec6,\u5f00\u7968\u5546\u54c1\u4e3a\u71c3\u6599\u6cb9\u65f6\uff0c\u5176\u201c\u5355\u4f4d\u201d\u680f\u5fc5\u987b\u9009\u62e9\u201c\u5428\u201d\u6216\u201c\u5347\u201d\u4e14\u4e0d\u80fd\u4e3a\u7a7a\u3002", cpyDetail.getRowNum()));
                }
            });
        }
        catch (Throwable e) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(ExceptionUtil.toDesc((Throwable)e)));
        }
        return result;
    }

    public List<CPYDetail> getCpyDetailList() {
        return this.cpyDetailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public Integer getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setCpyDetailList(List<CPYDetail> cpyDetailList) {
        this.cpyDetailList = cpyDetailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public void setInvoiceNumber(Integer invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CPYBaseValidator)) {
            return false;
        }
        CPYBaseValidator other = (CPYBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CPYDetail> this$cpyDetailList = this.getCpyDetailList();
        List<CPYDetail> other$cpyDetailList = other.getCpyDetailList();
        if (this$cpyDetailList == null ? other$cpyDetailList != null : !((Object)this$cpyDetailList).equals(other$cpyDetailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        if (this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList)) {
            return false;
        }
        Integer this$invoiceNumber = this.getInvoiceNumber();
        Integer other$invoiceNumber = other.getInvoiceNumber();
        return !(this$invoiceNumber == null ? other$invoiceNumber != null : !((Object)this$invoiceNumber).equals(other$invoiceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CPYBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CPYDetail> $cpyDetailList = this.getCpyDetailList();
        result = result * 59 + ($cpyDetailList == null ? 43 : ((Object)$cpyDetailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        Integer $invoiceNumber = this.getInvoiceNumber();
        result = result * 59 + ($invoiceNumber == null ? 43 : ((Object)$invoiceNumber).hashCode());
        return result;
    }

    public String toString() {
        return "CPYBaseValidator(cpyDetailList=" + this.getCpyDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ", invoiceNumber=" + this.getInvoiceNumber() + ")";
    }

    public static class CPYDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u6210\u54c1\u6cb9\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;
        @Alias(value="\u6210\u54c1\u6cb9\u6570\u91cf")
        @NotNull
        private BigDecimal quantity;
        @Alias(value="\u6210\u54c1\u6cb9\u5355\u4ef7")
        @NotNull
        private BigDecimal unitPrice;
        @Alias(value="\u6210\u54c1\u6cb9\u5355\u4f4d")
        @NotEmpty
        @Pattern(regexp="\u5347|\u5428")
        private @NotEmpty @Pattern(regexp="\u5347|\u5428") String unit;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public BigDecimal getUnitPrice() {
            return this.unitPrice;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CPYDetail)) {
                return false;
            }
            CPYDetail other = (CPYDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
                return false;
            }
            BigDecimal this$quantity = this.getQuantity();
            BigDecimal other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            BigDecimal this$unitPrice = this.getUnitPrice();
            BigDecimal other$unitPrice = other.getUnitPrice();
            if (this$unitPrice == null ? other$unitPrice != null : !((Object)this$unitPrice).equals(other$unitPrice)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CPYDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            BigDecimal $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            BigDecimal $unitPrice = this.getUnitPrice();
            result = result * 59 + ($unitPrice == null ? 43 : ((Object)$unitPrice).hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "CPYBaseValidator.CPYDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", quantity=" + this.getQuantity() + ", unitPrice=" + this.getUnitPrice() + ", unit=" + this.getUnit() + ")";
        }
    }
}

