/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000002Exception;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.constant.TransportationTypeEnum;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.CapabilityCodeEnum;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class TransportServiceValidator {
    @Alias(value="\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u5217\u8868")
    private List<TransportServiceDetail> transportServiceDetailList;
    private List<String> capabilityCodeList;
    private List<TransportServiceInfo> transportServiceInfoList;

    public ValidateResult validate() {
        ValidateResult result = ValidateResult.success();
        if (this.transportServiceDetailList == null || this.transportServiceDetailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.transportServiceInfoList == null || this.transportServiceInfoList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8d27\u7269\u8fd0\u8f93\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        for (int i = 0; i < this.transportServiceInfoList.size(); ++i) {
            TransportServiceInfo transportServiceInfo = this.transportServiceInfoList.get(i);
            if (transportServiceInfo == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u6761\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\uff0c\u8d27\u7269\u8fd0\u8f93\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (StringUtils.isBlank((CharSequence)transportServiceInfo.getPlaceOfShipment())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u6761\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\uff0c\u8d27\u7269\u8fd0\u8f93\u8d77\u8fd0\u5730\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (StringUtils.isBlank((CharSequence)transportServiceInfo.getDestination())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u6761\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\uff0c\u8d27\u7269\u8fd0\u8f93\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (StringUtils.isBlank((CharSequence)transportServiceInfo.getToolBrand())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u6761\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\uff0c\u8d27\u7269\u8fd0\u8f93\u8fd0\u8f93\u5de5\u5177\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (StringUtils.isBlank((CharSequence)transportServiceInfo.getNameOfGoods())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u6761\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\uff0c\u8d27\u7269\u8fd0\u8f93\u8fd0\u8f93\u8d27\u7269\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (transportServiceInfo.getToolType() != null) continue;
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8d27\u7269\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3001\u4e14\u5e94\u4e3a[\u94c1\u8def\u8fd0\u8f93\u3001\u516c\u8def\u8fd0\u8f93\u3001\u6c34\u8def\u8fd0\u8f93\u3001\u822a\u7a7a\u8fd0\u8f93\u3001\u7ba1\u9053\u8fd0\u8f93]\u4e2d\u4e4b\u4e00"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("04")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8bf7\u524d\u5f80\u7535\u5b50\u7a0e\u5c40\u201c\u4e50\u4f01\u6570\u5b57\u5f00\u653e\u5e73\u53f0\u201d\u68c0\u67e5\u6240\u4f7f\u7528\u7684[%s]\u662f\u5426\u5df2\u88ab\u6388\u6743\u9080\u8bf7", CapabilityCodeEnum.fromCode((String)"04").toDesc())));
            return result;
        }
        return result;
    }

    public void validateTransportServiceData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        List<TransportServiceDetail> transportServiceDetailList = this.getTransportServiceDetailList();
        List<String> transportServiceGoodTaxNoList = provider.provideGoodsTaxNo();
        transportServiceDetailList.forEach(detail -> {
            if (!transportServiceGoodTaxNoList.contains(detail.getGoodsTaxNo())) {
                throw new TXWR000002Exception(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e2d\u8d27\u7269\u8fd0\u8f93\u7c7b\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", detail.getRowNum()));
            }
        });
    }

    public List<TransportServiceDetail> getTransportServiceDetailList() {
        return this.transportServiceDetailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public List<TransportServiceInfo> getTransportServiceInfoList() {
        return this.transportServiceInfoList;
    }

    public void setTransportServiceDetailList(List<TransportServiceDetail> transportServiceDetailList) {
        this.transportServiceDetailList = transportServiceDetailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public void setTransportServiceInfoList(List<TransportServiceInfo> transportServiceInfoList) {
        this.transportServiceInfoList = transportServiceInfoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportServiceValidator)) {
            return false;
        }
        TransportServiceValidator other = (TransportServiceValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TransportServiceDetail> this$transportServiceDetailList = this.getTransportServiceDetailList();
        List<TransportServiceDetail> other$transportServiceDetailList = other.getTransportServiceDetailList();
        if (this$transportServiceDetailList == null ? other$transportServiceDetailList != null : !((Object)this$transportServiceDetailList).equals(other$transportServiceDetailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        if (this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList)) {
            return false;
        }
        List<TransportServiceInfo> this$transportServiceInfoList = this.getTransportServiceInfoList();
        List<TransportServiceInfo> other$transportServiceInfoList = other.getTransportServiceInfoList();
        return !(this$transportServiceInfoList == null ? other$transportServiceInfoList != null : !((Object)this$transportServiceInfoList).equals(other$transportServiceInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransportServiceValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TransportServiceDetail> $transportServiceDetailList = this.getTransportServiceDetailList();
        result = result * 59 + ($transportServiceDetailList == null ? 43 : ((Object)$transportServiceDetailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        List<TransportServiceInfo> $transportServiceInfoList = this.getTransportServiceInfoList();
        result = result * 59 + ($transportServiceInfoList == null ? 43 : ((Object)$transportServiceInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "TransportServiceValidator(transportServiceDetailList=" + this.getTransportServiceDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ", transportServiceInfoList=" + this.getTransportServiceInfoList() + ")";
    }

    public static class TransportServiceInfo {
        private String placeOfShipment;
        private String destination;
        private TransportationTypeEnum toolType;
        private String toolBrand;
        private String nameOfGoods;

        public String getPlaceOfShipment() {
            return this.placeOfShipment;
        }

        public String getDestination() {
            return this.destination;
        }

        public TransportationTypeEnum getToolType() {
            return this.toolType;
        }

        public String getToolBrand() {
            return this.toolBrand;
        }

        public String getNameOfGoods() {
            return this.nameOfGoods;
        }

        public void setPlaceOfShipment(String placeOfShipment) {
            this.placeOfShipment = placeOfShipment;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public void setToolType(TransportationTypeEnum toolType) {
            this.toolType = toolType;
        }

        public void setToolBrand(String toolBrand) {
            this.toolBrand = toolBrand;
        }

        public void setNameOfGoods(String nameOfGoods) {
            this.nameOfGoods = nameOfGoods;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransportServiceInfo)) {
                return false;
            }
            TransportServiceInfo other = (TransportServiceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$placeOfShipment = this.getPlaceOfShipment();
            String other$placeOfShipment = other.getPlaceOfShipment();
            if (this$placeOfShipment == null ? other$placeOfShipment != null : !this$placeOfShipment.equals(other$placeOfShipment)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                return false;
            }
            TransportationTypeEnum this$toolType = this.getToolType();
            TransportationTypeEnum other$toolType = other.getToolType();
            if (this$toolType == null ? other$toolType != null : !((Object)((Object)this$toolType)).equals((Object)other$toolType)) {
                return false;
            }
            String this$toolBrand = this.getToolBrand();
            String other$toolBrand = other.getToolBrand();
            if (this$toolBrand == null ? other$toolBrand != null : !this$toolBrand.equals(other$toolBrand)) {
                return false;
            }
            String this$nameOfGoods = this.getNameOfGoods();
            String other$nameOfGoods = other.getNameOfGoods();
            return !(this$nameOfGoods == null ? other$nameOfGoods != null : !this$nameOfGoods.equals(other$nameOfGoods));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransportServiceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $placeOfShipment = this.getPlaceOfShipment();
            result = result * 59 + ($placeOfShipment == null ? 43 : $placeOfShipment.hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            TransportationTypeEnum $toolType = this.getToolType();
            result = result * 59 + ($toolType == null ? 43 : ((Object)((Object)$toolType)).hashCode());
            String $toolBrand = this.getToolBrand();
            result = result * 59 + ($toolBrand == null ? 43 : $toolBrand.hashCode());
            String $nameOfGoods = this.getNameOfGoods();
            result = result * 59 + ($nameOfGoods == null ? 43 : $nameOfGoods.hashCode());
            return result;
        }

        public String toString() {
            return "TransportServiceValidator.TransportServiceInfo(placeOfShipment=" + this.getPlaceOfShipment() + ", destination=" + this.getDestination() + ", toolType=" + this.getToolType() + ", toolBrand=" + this.getToolBrand() + ", nameOfGoods=" + this.getNameOfGoods() + ")";
        }
    }

    public static class TransportServiceDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u8d27\u7269\u8fd0\u8f93\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransportServiceDetail)) {
                return false;
            }
            TransportServiceDetail other = (TransportServiceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            return !(this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransportServiceDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            return result;
        }

        public String toString() {
            return "TransportServiceValidator.TransportServiceDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ")";
        }
    }
}

