package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @author Thj
 * @createdAt: 2023/2/8 16:36
 * @Description:
 */
@Data
public class BuyerInfo {

    /**
     * 购买方统一社会信用代码/纳税人识别号/身份证件号码（非必须）
     */
    @Alias("购买方统一社会信用代码")
    @Length(max = 20)
    @Pattern(regexp = "^$|[A-Z0-9]+")
    private String buyerTaxNo;

    /**
     * 购买方名称
     */
    @Alias("购买方名称")
    @NotEmpty
    @Length(max = 300)
    private String buyerName;

    /**
     * 购买方地址（非必须）
     */
    @Alias("购买方地址")
    @Length(max = 300)
    private String buyerAddress;

    /**
     * 购买方电话（非必须）
     */
    @Alias("购买方电话")
    @Length(max = 60)
    private String buyerTel;

    /**
     * 购买方开户行（非必须）
     */
    @Alias("购买方开户行")
    @Length(max = 120)
    private String buyerBankName;

    /**
     * 购买方账号（非必须）
     */
    @Alias("购买方账号")
    @Length(max = 50)
    private String buyerBankAccount;

    /**
     * 购买方经办人姓名（非必须）
     */
    @Alias("购买方经办人姓名")
    @Length(max = 150)
    private String buyerOperatorName;

    /**
     * 购买方经办人证件号码（非必须）
     */
    @Alias("购买方经办人证件号码")
    @Length(max = 30)
    private String buyerOperatorIdentityNo;

    /**
     * 购买方经办人联系电话（非必须）
     * jbrlxdh修改为gmfjbrlxdh
     */
    @Alias("购买方经办人联系电话")
    @Length(max = 60)
    private String buyerOperatorTel;

    @Alias("购方经办人证件类型")
    @Length(max = 3)
    private String buyerOperatorIdentityType;

    @Alias("购方经办人国籍")
    @Length(max = 3)
    private String buyerOperatorNationality;

    @Alias("购方经办人纳税人识别号")
    @Length(max = 30)
    private String buyerOperatorTaxNo;
}
