package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author Thj
 * @createdAt: 2023/2/8 16:37
 * @Description:
 */
@Data
public class InvoiceAmountInfo {

    /**
     * 合计金额
     */
    @Alias("合计金额")
    @NotNull
    @Digits(integer = 18, fraction = 2)
    private BigDecimal amountWithoutTax;

    /**
     * 合计税额
     */
    @Alias("合计税额")
    @NotNull
    @Digits(integer = 18, fraction = 2)
    private BigDecimal taxAmount;

    /**
     * 价税合计
     */
    @Alias("价税合计")
    @NotNull
    @Digits(integer = 18, fraction = 2)
    private BigDecimal amountWithTax;

    public BigDecimal getAmountWithTax() {
        if (this.amountWithTax == null) {
            if (this.amountWithoutTax == null || this.taxAmount == null) {
                return BigDecimal.ZERO;
            }

            this.setAmountWithTax(this.amountWithoutTax.add(taxAmount));
        }

        return amountWithTax;
    }
}
