package com.xforceplus.taxware.chestnut.check.model.base;


import lombok.Data;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
@Data
public class InvoiceStatusInfo {

    /**
     * 发票代码
     * 全电发票发票代码可为空
     */
    private String invoiceCode;

    /**
     * 发票号码
     * 全电发票，发票号码20位
     */
    private String invoiceNo;

    /**
     * 开票日期
     * YYYY-MM-DD HH:mm:ss
     */
    private String dateTimeIssued;

    /**
     * 发票状态（非必须）
     * 0-正常
     * 2-作废
     * 3-已红冲
     * 7-部分红冲
     * 8-全额冲红
     */
    private String status;

    /**
     * 异常凭证状态（非必须）-风险状态
     * 01-正常
     * 02-异常凭证
     * 03-疑似异常凭证
     */
    private String riskStatus;

    /**
     * 红字锁定标识（非必须）
     * Y-锁定；N-未锁定
     */
    private String redLetterBlockFlag;

    /**
     * 发票用途（非必须）
     * 0-未使用
     * 1-已申请抵扣
     * 2-已申请退税
     * 3-已申请代办退税
     * 4-已勾选不抵扣（历史数据）
     * 5-已申请代办退税（历史数据）
     * 6-已申请不抵扣
     * 7-内销转出口
     * 8-出口转内销
     * 9-准予退税
     * 10-不予退税
     * 11-冬奥退税
     * 12-农产品加计扣除
     */
    private String vatUsageLabel;

    /**
     * 入账状态（非必须）
     * 01-未入账
     * 02-已入账
     * 03-已入账撤销
     */
    private String entryStatus;

    /**
     * 成品油异常标识（非必须）
     * 9-正常
     * 1-成品油单价异常
     * 2-成品油超库存异常
     */
    private String oilAbnormalFlag;

    /**
     * 出口退税类代码（非必须）
     * 01-增值税专用发票可用于代办退税标签（仅用于代办退税）
     */
    private String exportPolicyCode;

    /**
     * 增值税优惠用途（农产品加计扣除，非必须）
     * 0：未使用
     * 1：全部项目加计
     * 2：全部项目不加计
     * 3：部分项目加计
     */
    private String vatPreUsage;

    /**
     * 消费税用途
     * 00：未勾选库存
     * 01：已勾选库存
     */
    private String exciseUsage;
}
