package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;

/**
 * @author Thj
 * @createdAt: 2023/2/8 16:38
 * @Description:
 */
@Data
public class OperatorInfo {

    /**
     * 开票人
     */
    @Alias("开票人")
    @NotEmpty
    @Length(max = 300)
    private String issuer;

    /**
     * 开票人证件号码（非必须）
     */
    @Alias("开票人证件号码")
    @Length(max = 30)
    private String issuerIdentityNo;

    /**
     * 开票人证件类型（非必须）
     */
    @Alias("开票人证件类型")
    @Length(max = 4)
    private String issuerIdentityType;
}
