/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.util;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class BasicValidator {
    private static final Validator validator;

    public static <T> ValidateResult validate(T t) {
        return BasicValidator.validate(t, null);
    }

    public static <T> ValidateResult validate(T t, String rowNum) {
        Set constraintViolations = validator.validate(t, new Class[0]);
        if (constraintViolations.size() > 0) {
            ArrayList<ValidateResult.ErrorInfo> errorInfoList = new ArrayList<ValidateResult.ErrorInfo>();
            constraintViolations.forEach(next -> {
                ValidateResult.ErrorInfo errorInfo = new ValidateResult.ErrorInfo();
                String filedName = BasicValidator.getFriendlyName(next);
                String indexMessage = "";
                if (rowNum != null && rowNum.length() > 0) {
                    indexMessage = String.format("\u7b2c%s\u884c", rowNum);
                }
                errorInfo.setRowNum(rowNum);
                errorInfo.setErrorFieldName(filedName);
                errorInfo.setErrorMessage(String.format("%s%s%s", indexMessage, filedName, next.getMessage()));
                errorInfoList.add(errorInfo);
            });
            return ValidateResult.fail(errorInfoList);
        }
        return ValidateResult.success();
    }

    private static <T> String getFriendlyName(ConstraintViolation<T> next) {
        String filedName = next.getPropertyPath().toString();
        try {
            if (filedName != null && filedName.length() > 0) {
                Alias alias = next.getRootBeanClass().getDeclaredField(next.getPropertyPath().toString()).getAnnotation(Alias.class);
                if (alias == null) {
                    return filedName;
                }
                filedName = alias.value();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filedName;
    }

    public static ValidateResult mergeValidateResult(ValidateResult v1, ValidateResult v2) {
        if (v1.isSuccess() && v2.isSuccess()) {
            return ValidateResult.success();
        }
        ArrayList<ValidateResult.ErrorInfo> errorInfoList = new ArrayList<ValidateResult.ErrorInfo>();
        if (v1.getErrorInfoList() != null) {
            errorInfoList.addAll(v1.getErrorInfoList());
        }
        if (v2.getErrorInfoList() != null) {
            errorInfoList.addAll(v2.getErrorInfoList());
        }
        return ValidateResult.fail(errorInfoList);
    }

    static {
        ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).defaultLocale(Locale.SIMPLIFIED_CHINESE)).buildValidatorFactory();
        validator = factory.getValidator();
    }
}

