/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.CapabilityCodeEnum;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class BuildingServiceValidator {
    @Alias(value="\u5efa\u7b51\u670d\u52a1\u660e\u7ec6\u5217\u8868")
    private List<BuildingServiceDetail> buildingServiceDetailList;
    private List<String> capabilityCodeList;
    private BuildingServiceInfo buildingServiceInfo;

    public ValidateResult validate() {
        ValidateResult result = ValidateResult.success();
        if (this.buildingServiceDetailList == null || this.buildingServiceDetailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5efa\u7b51\u670d\u52a1\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.buildingServiceDetailList.size() != 1) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5efa\u7b51\u670d\u52a1\u53d1\u7968\u660e\u7ec6\u53ea\u80fd\u6709\u4e00\u884c\uff0c\u4f20\u5165\u884c\u6570\u3010%s\u3011", this.buildingServiceDetailList.size())));
            return result;
        }
        if (this.buildingServiceInfo == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5efa\u7b51\u670d\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (StringUtils.isBlank((CharSequence)this.buildingServiceInfo.getPlace())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.buildingServiceInfo.getPlace().length() > 120) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7120\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", this.buildingServiceInfo.getPlace(), this.buildingServiceInfo.getPlace().length())));
            return result;
        }
        if (StringUtils.isBlank((CharSequence)this.buildingServiceInfo.getEntryName())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u5efa\u7b51\u670d\u52a1\u5efa\u7b51\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.buildingServiceInfo.getEntryName().length() > 80) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5efa\u7b51\u670d\u52a1\u5efa\u7b51\u9879\u76ee\u540d\u79f0\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc780\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", this.buildingServiceInfo.getEntryName(), this.buildingServiceInfo.getEntryName().length())));
            return result;
        }
        if (this.buildingServiceInfo.getCrossCitySign() == null) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.buildingServiceInfo.getCrossCitySign().booleanValue() && StringUtils.isEmpty((CharSequence)this.buildingServiceInfo.getCrossRegionalTaxManageNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7\u5fc5\u586b"));
            return result;
        }
        if (!this.buildingServiceInfo.getCrossCitySign().booleanValue() && StringUtils.isNotEmpty((CharSequence)this.buildingServiceInfo.getCrossRegionalTaxManageNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7\u5fc5\u987b\u4e3a\u7a7a\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", this.buildingServiceInfo.getCrossRegionalTaxManageNo())));
            return result;
        }
        if (this.buildingServiceInfo.getCrossRegionalTaxManageNo() != null && this.buildingServiceInfo.getCrossRegionalTaxManageNo().length() > 50) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", this.buildingServiceInfo.getCrossRegionalTaxManageNo(), this.buildingServiceInfo.getCrossRegionalTaxManageNo().length())));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("03")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8bf7\u524d\u5f80\u7535\u5b50\u7a0e\u5c40\u201c\u4e50\u4f01\u6570\u5b57\u5f00\u653e\u5e73\u53f0\u201d\u68c0\u67e5\u6240\u4f7f\u7528\u7684[%s]\u662f\u5426\u5df2\u88ab\u6388\u6743\u9080\u8bf7", CapabilityCodeEnum.fromCode((String)"03").toDesc())));
            return result;
        }
        return result;
    }

    public ValidateResult validateBuildingServiceData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        BuildingServiceDetail buildingServiceDetail = this.getBuildingServiceDetailList().get(0);
        List<String> buildingServiceGoodTaxNoList = provider.provideGoodsTaxNo();
        if (!buildingServiceGoodTaxNoList.contains(buildingServiceDetail.getGoodsTaxNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e2d\u5efa\u7b51\u670d\u52a1\u7c7b\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u3002\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", buildingServiceDetail.getGoodsTaxNo())));
            return result;
        }
        return result;
    }

    public List<BuildingServiceDetail> getBuildingServiceDetailList() {
        return this.buildingServiceDetailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public BuildingServiceInfo getBuildingServiceInfo() {
        return this.buildingServiceInfo;
    }

    public void setBuildingServiceDetailList(List<BuildingServiceDetail> buildingServiceDetailList) {
        this.buildingServiceDetailList = buildingServiceDetailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public void setBuildingServiceInfo(BuildingServiceInfo buildingServiceInfo) {
        this.buildingServiceInfo = buildingServiceInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildingServiceValidator)) {
            return false;
        }
        BuildingServiceValidator other = (BuildingServiceValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BuildingServiceDetail> this$buildingServiceDetailList = this.getBuildingServiceDetailList();
        List<BuildingServiceDetail> other$buildingServiceDetailList = other.getBuildingServiceDetailList();
        if (this$buildingServiceDetailList == null ? other$buildingServiceDetailList != null : !((Object)this$buildingServiceDetailList).equals(other$buildingServiceDetailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        if (this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList)) {
            return false;
        }
        BuildingServiceInfo this$buildingServiceInfo = this.getBuildingServiceInfo();
        BuildingServiceInfo other$buildingServiceInfo = other.getBuildingServiceInfo();
        return !(this$buildingServiceInfo == null ? other$buildingServiceInfo != null : !((Object)this$buildingServiceInfo).equals(other$buildingServiceInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildingServiceValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BuildingServiceDetail> $buildingServiceDetailList = this.getBuildingServiceDetailList();
        result = result * 59 + ($buildingServiceDetailList == null ? 43 : ((Object)$buildingServiceDetailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        BuildingServiceInfo $buildingServiceInfo = this.getBuildingServiceInfo();
        result = result * 59 + ($buildingServiceInfo == null ? 43 : ((Object)$buildingServiceInfo).hashCode());
        return result;
    }

    public String toString() {
        return "BuildingServiceValidator(buildingServiceDetailList=" + this.getBuildingServiceDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ", buildingServiceInfo=" + this.getBuildingServiceInfo() + ")";
    }

    public static class BuildingServiceDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u5efa\u7b51\u670d\u52a1\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildingServiceDetail)) {
                return false;
            }
            BuildingServiceDetail other = (BuildingServiceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            return !(this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BuildingServiceDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            return result;
        }

        public String toString() {
            return "BuildingServiceValidator.BuildingServiceDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ")";
        }
    }

    public static class BuildingServiceInfo {
        private String place;
        private String entryName;
        private Boolean crossCitySign;
        private String crossRegionalTaxManageNo;

        public String getPlace() {
            return this.place;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public Boolean getCrossCitySign() {
            return this.crossCitySign;
        }

        public String getCrossRegionalTaxManageNo() {
            return this.crossRegionalTaxManageNo;
        }

        public void setPlace(String place) {
            this.place = place;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public void setCrossCitySign(Boolean crossCitySign) {
            this.crossCitySign = crossCitySign;
        }

        public void setCrossRegionalTaxManageNo(String crossRegionalTaxManageNo) {
            this.crossRegionalTaxManageNo = crossRegionalTaxManageNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildingServiceInfo)) {
                return false;
            }
            BuildingServiceInfo other = (BuildingServiceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$place = this.getPlace();
            String other$place = other.getPlace();
            if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
                return false;
            }
            String this$entryName = this.getEntryName();
            String other$entryName = other.getEntryName();
            if (this$entryName == null ? other$entryName != null : !this$entryName.equals(other$entryName)) {
                return false;
            }
            Boolean this$crossCitySign = this.getCrossCitySign();
            Boolean other$crossCitySign = other.getCrossCitySign();
            if (this$crossCitySign == null ? other$crossCitySign != null : !((Object)this$crossCitySign).equals(other$crossCitySign)) {
                return false;
            }
            String this$crossRegionalTaxManageNo = this.getCrossRegionalTaxManageNo();
            String other$crossRegionalTaxManageNo = other.getCrossRegionalTaxManageNo();
            return !(this$crossRegionalTaxManageNo == null ? other$crossRegionalTaxManageNo != null : !this$crossRegionalTaxManageNo.equals(other$crossRegionalTaxManageNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BuildingServiceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $place = this.getPlace();
            result = result * 59 + ($place == null ? 43 : $place.hashCode());
            String $entryName = this.getEntryName();
            result = result * 59 + ($entryName == null ? 43 : $entryName.hashCode());
            Boolean $crossCitySign = this.getCrossCitySign();
            result = result * 59 + ($crossCitySign == null ? 43 : ((Object)$crossCitySign).hashCode());
            String $crossRegionalTaxManageNo = this.getCrossRegionalTaxManageNo();
            result = result * 59 + ($crossRegionalTaxManageNo == null ? 43 : $crossRegionalTaxManageNo.hashCode());
            return result;
        }

        public String toString() {
            return "BuildingServiceValidator.BuildingServiceInfo(place=" + this.getPlace() + ", entryName=" + this.getEntryName() + ", crossCitySign=" + this.getCrossCitySign() + ", crossRegionalTaxManageNo=" + this.getCrossRegionalTaxManageNo() + ")";
        }
    }
}

