/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.base.BaseInvoiceInfo;
import com.xforceplus.taxware.chestnut.check.model.base.BuyerInfo;
import com.xforceplus.taxware.chestnut.check.model.base.InvoiceAmountInfo;
import com.xforceplus.taxware.chestnut.check.model.base.NatureInfo;
import com.xforceplus.taxware.chestnut.check.model.base.OperatorInfo;
import com.xforceplus.taxware.chestnut.check.model.base.RedLetterInfo;
import com.xforceplus.taxware.chestnut.check.model.base.SellerInfo;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.check.model.util.CommonUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.hibernate.validator.constraints.Length;

public class InvoiceBaseValidator {
    private BaseInvoiceInfo invoiceBaseInfo;
    private SellerInfo sellerInfo;
    private BuyerInfo buyerInfo;
    private NatureInfo natureInfo;
    private InvoiceAmountInfo invoiceAmountInfo;
    private OperatorInfo operatorInfo;
    private RedLetterInfo redLetterInfo;
    private List<InvoiceDetail> invoiceDetailList;

    public ValidateResult validate() {
        AtomicReference<ValidateResult> result = new AtomicReference<ValidateResult>(BasicValidator.validate(this));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getInvoiceBaseInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getSellerInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getBuyerInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getNatureInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getInvoiceAmountInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getOperatorInfo())));
        result.set(BasicValidator.mergeValidateResult(result.get(), BasicValidator.validate(this.getRedLetterInfo())));
        List<InvoiceDetail> detailList = this.getInvoiceDetailList();
        if (detailList == null || detailList.size() == 0) {
            result.set(BasicValidator.mergeValidateResult(result.get(), ValidateResult.fail("\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a")));
            return result.get();
        }
        StopWatch watch1 = StopWatch.createStarted();
        ValidateResult validateResult = this.detailBaseValidate(detailList);
        result.set(BasicValidator.mergeValidateResult(result.get(), validateResult));
        watch1.stop();
        LogContext.setLogPoint((String)"watch1", (Object)watch1.getTime());
        watch1.reset();
        StopWatch watch2 = StopWatch.createStarted();
        if (result.get().isSuccess()) {
            result.set(BasicValidator.mergeValidateResult(result.get(), this.validateData()));
        }
        watch2.stop();
        LogContext.setLogPoint((String)"watch2", (Object)watch2.getTime());
        watch2.reset();
        return result.get();
    }

    private ValidateResult detailBaseValidate(List<InvoiceDetail> detailList) {
        ValidateResult result = ValidateResult.success();
        for (InvoiceDetail detail : detailList) {
            Matcher taxIncentivesTypeMatcher;
            if (detail == null) continue;
            if (detail.getRowNum() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u62a5\u6587\u4e2d\uff0c\u660e\u7ec6\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff08\u7531\u4e8e\u672a\u4f20\u5165\u5e8f\u53f7\uff0c\u4e0d\u786e\u5b9a\u662f\u54ea\u4e00\u884c\uff09"));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getGoodsTaxNo()) && detail.getGoodsTaxNo().length() > 19) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u7a0e\u7f16\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e19\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getGoodsTaxNo(), detail.getGoodsTaxNo().length())));
            }
            if (StringUtils.isBlank((CharSequence)detail.getItemName())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", detail.getRowNum())));
                continue;
            }
            if (detail.getItemName().length() > 600) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u9879\u76ee\u540d\u79f0\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e600\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getItemName(), detail.getItemName().length())));
            }
            String regex = "\\*.+?\\*[\\s\\S]+|.*(\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355).*|.*(\u8be6\u89c1\u9500\u8d27\u6e05\u5355).*";
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("\\*.+?\\*[\\s\\S]+|.*(\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355).*|.*(\u8be6\u89c1\u9500\u8d27\u6e05\u5355).*");
            Matcher matcher = pattern.matcher(detail.getItemName());
            if (!matcher.matches()) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u9879\u76ee\u540d\u79f0\u5fc5\u987b\u7b26\u5408\u89c4\u8303(*A*B|\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355|\u8be6\u89c1\u9500\u8d27\u6e05\u5355)\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getItemName())));
            }
            if (StringUtils.isBlank((CharSequence)detail.getDiscountType())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u53d1\u7968\u884c\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a", detail.getRowNum())));
                continue;
            }
            if (detail.getDiscountType().length() > 2) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u53d1\u7968\u884c\u6027\u8d28\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e2\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getDiscountType())));
            }
            String discountRegex = "0[0-2]";
            java.util.regex.Pattern discountPattern = java.util.regex.Pattern.compile("0[0-2]");
            Matcher discountMatcher = discountPattern.matcher(detail.getDiscountType());
            if (!discountMatcher.matches()) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u53d1\u7968\u884c\u6027\u8d28\u5fc5\u987b\u7b26\u5408\u89c4\u8303(01|02)\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getDiscountType())));
            }
            String taxIncentivesTypeRegex = "^$|0[1-9]|1[0-8]";
            java.util.regex.Pattern taxIncentivesTypePattern = java.util.regex.Pattern.compile("^$|0[1-9]|1[0-8]");
            if (StringUtils.isNotBlank((CharSequence)detail.getTaxIncentivesType()) && !(taxIncentivesTypeMatcher = taxIncentivesTypePattern.matcher(detail.getTaxIncentivesType())).matches()) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u5fc5\u987b\u7b26\u5408\u89c4\u8303(01-9|10-8)\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getTaxIncentivesType())));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getSpecifications()) && detail.getSpecifications().length() > 150) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u89c4\u683c\u578b\u53f7\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e150\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u3010%s\u3011", detail.getRowNum(), detail.getSpecifications(), detail.getSpecifications().length())));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getUnit()) && detail.getUnit().length() > 300) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u5355\u4f4d\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e300\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u3010%s\u3011", detail.getRowNum(), detail.getUnit(), detail.getUnit().length())));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getUnitPrice()) && detail.getUnitPrice().length() > 25) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u5355\u4ef7\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e25\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u3010%s\u3011", detail.getRowNum(), detail.getUnitPrice(), detail.getUnitPrice().length())));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getQuantity()) && detail.getQuantity().length() > 25) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u6570\u91cf\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e25\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u3010%s\u3011", detail.getRowNum(), detail.getQuantity(), detail.getQuantity().length())));
            }
            if (detail.getAmountWithoutTax() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", detail.getRowNum())));
                continue;
            }
            if (detail.getAmountWithoutTax().stripTrailingZeros().scale() > 2 || detail.getAmountWithoutTax().stripTrailingZeros().scale() + detail.getAmountWithoutTax().stripTrailingZeros().precision() > 20) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u91d1\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc718\uff0c\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc72\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getAmountWithoutTax())));
            }
            if (detail.getTaxAmount() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a", detail.getRowNum())));
                continue;
            }
            if (detail.getTaxAmount().stripTrailingZeros().scale() > 2 || detail.getTaxAmount().stripTrailingZeros().scale() + detail.getTaxAmount().stripTrailingZeros().precision() > 20) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u7a0e\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc718\uff0c\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc72\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getTaxAmount())));
            }
            if (detail.getAmountWithTax() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", detail.getRowNum())));
                continue;
            }
            if (detail.getAmountWithTax().stripTrailingZeros().scale() > 2 || detail.getAmountWithTax().stripTrailingZeros().scale() + detail.getAmountWithTax().stripTrailingZeros().precision() > 20) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc718\uff0c\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc72\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getAmountWithTax())));
            }
            if (detail.getTaxRate() != null && (detail.getTaxRate().stripTrailingZeros().scale() > 6 || detail.getTaxRate().stripTrailingZeros().scale() + detail.getTaxRate().stripTrailingZeros().precision() > 22)) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u7a0e\u7387\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc716\uff0c\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc76\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getTaxRate())));
            }
            if (detail.getDeduction() != null && (detail.getDeduction().stripTrailingZeros().scale() > 2 || detail.getDeduction().stripTrailingZeros().scale() + detail.getDeduction().stripTrailingZeros().precision() > 18)) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u53d1\u7968\u660e\u7ec6\uff0c\u6263\u9664\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc718\uff0c\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc72\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getDeduction())));
            }
            if (detailList.size() < 200 || result.isSuccess()) continue;
            return result;
        }
        return result;
    }

    private ValidateResult validateData() {
        BigDecimal invoiceTotalTaxAmount;
        BigDecimal invoiceTotalAmount;
        ValidateResult result = ValidateResult.success();
        if ("0".equals(this.invoiceBaseInfo.getInvoiceFlag()) && (StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getRedLetterNumber()) || StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getOriginalInvoiceNo()) || StringUtils.isNotEmpty((CharSequence)this.redLetterInfo.getOriginalDateIssued()))) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u84dd\u5b57\u53d1\u7968\u5bf9\u5e94\u7684\u7ea2\u5b57\u53d1\u7968\u76f8\u5173\u53c2\u6570\u5e94\u4e3a\u7a7a"));
        }
        if ("1".equals(this.invoiceBaseInfo.getInvoiceFlag()) && this.redLetterInfo != null && (this.redLetterInfo.getRedLetterNumber() == null || this.redLetterInfo.getRedLetterNumber().trim().isEmpty() || this.redLetterInfo.getOriginalInvoiceNo() == null || this.redLetterInfo.getOriginalInvoiceNo().trim().isEmpty())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u84dd\u5b57\u53d1\u7968\u5bf9\u5e94\u7684\u7ea2\u5b57\u53d1\u7968\u76f8\u5173\u53c2\u6570\u5e94\u4e3a\u7a7a"));
        }
        if ((invoiceTotalAmount = this.getInvoiceAmountInfo().getAmountWithTax()).compareTo((invoiceTotalTaxAmount = this.getInvoiceAmountInfo().getTaxAmount()).add(this.getInvoiceAmountInfo().getAmountWithoutTax())) != 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7968\u9762\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u91d1\u989d\u52a0\u7a0e\u989d\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s!=%s+%s\u3011", invoiceTotalAmount, this.getInvoiceAmountInfo().getAmountWithoutTax(), invoiceTotalTaxAmount)));
        }
        if ("1".equals(this.invoiceBaseInfo.getInvoiceFlag())) {
            return result;
        }
        BigDecimal detailTotalAmount = BigDecimal.valueOf(0L);
        BigDecimal detailTotalTaxAmount = BigDecimal.valueOf(0L);
        List<InvoiceDetail> detailList = this.getInvoiceDetailList();
        for (int i = 0; i < detailList.size(); ++i) {
            InvoiceDetail detail = detailList.get(i);
            ValidateResult validateDataResult = detail.validateData();
            result = BasicValidator.mergeValidateResult(result, validateDataResult);
            if ("1".equals(this.getInvoiceBaseInfo().getInvoiceFlag()) && detail.getOriginalRowNum() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
                return result;
            }
            if (i + 1 != detail.getRowNum()) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5e8f\u53f7\u4e0d\u662f\u4ece1\u5f00\u59cb\u6216\u4e0d\u8fde\u7eed\u6216\u91cd\u590d"));
                return result;
            }
            if (detail.getRowNum() == 1) {
                if ("02".equals(detail.getDiscountType())) {
                    if (detailList.size() < 2) {
                        result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u7b2c\u4e00\u884c\u662f\u88ab\u6298\u6263\u884c,\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u5c11\u4e8e\u4e24\u884c"));
                        return result;
                    }
                    if (!detailList.get(1).getDiscountType().equals("01")) {
                        result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u88ab\u6298\u6263\u884c\u7684\u4e0b\u4e00\u884c\u5fc5\u987b\u4e3a\u6298\u6263\u884c"));
                    }
                } else if ("01".equals(detail.getDiscountType())) {
                    result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u7b2c\u4e00\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c"));
                }
            }
            if (!("00".equals(detail.getDiscountType()) || detail.getOriginalRowNum() == null && detail.getDeduction() == null)) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u6298\u6263\u884c\u4e0e\u88ab\u6298\u6263\u884c\u201c\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7\u201d\u3001\u201c\u6263\u9664\u989d\u201d\u5fc5\u987b\u4e3a\u7a7a\u3002"));
            }
            if ("01".equals(detail.getDiscountType()) && (StringUtils.isNotBlank((CharSequence)detail.getSpecifications()) || StringUtils.isNotBlank((CharSequence)detail.getUnitPrice()) || StringUtils.isNotBlank((CharSequence)detail.getUnit()) || StringUtils.isNotBlank((CharSequence)detail.getQuantity()))) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u6298\u6263\u884c\u201c\u89c4\u683c\u578b\u53f7\u201d\u3001\u201c\u5355\u4ef7\u201d\u3001\u201c\u5355\u4f4d\u201d\u3001\u201c\u6570\u91cf\u201d\u5fc5\u987b\u4e3a\u7a7a\uff1b\u4f20\u5165\u503c\u4e3a\u3010\u89c4\u683c\u578b\u53f7\uff1a%s-\u5355\u4ef7\uff1a%s-\u5355\u4f4d\uff1a%s-\u6570\u91cf\uff1a%s\u3011", CommonUtil.cleanBlankString(detail.getSpecifications()), CommonUtil.cleanBlankString(detail.getUnitPrice()), CommonUtil.cleanBlankString(detail.getUnit()), CommonUtil.cleanBlankString(detail.getQuantity()))));
            }
            if ("01".equals(detail.getDiscountType()) && !detailList.get(i - 1).getItemName().equals(detail.getItemName())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u5546\u54c1\u540d\u79f0\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4\uff0c\u6298\u6263\u884c\u4e3a\u3010%s\u3011\uff0c\u539f\u53d1\u7968\u884c\u4e3a\u3010%s\u3011", i + 1, detail.getItemName(), detailList.get(i - 1).getItemName())));
            }
            if ("01".equals(detail.getDiscountType()) && detailList.get(i - 1).getTaxRate().compareTo(detail.getTaxRate()) != 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4\uff0c\u6298\u6263\u884c\u4e3a\u3010%s\u3011\uff0c\u539f\u53d1\u7968\u884c\u4e3a\u3010%s\u3011", i + 1, detail.getTaxRate(), detailList.get(i - 1).getTaxRate())));
            }
            if ("01".equals(detail.getDiscountType()) && !detailList.get(i - 1).getGoodsTaxNo().equals(detail.getGoodsTaxNo())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4\uff0c\u6298\u6263\u884c\u4e3a\u3010%s\u3011\uff0c\u539f\u53d1\u7968\u884c\u4e3a\u3010%s\u3011", i + 1, detail.getGoodsTaxNo(), detailList.get(i - 1).getGoodsTaxNo())));
            }
            if ("01".equals(detail.getDiscountType()) && !Objects.equals(detailList.get(i - 1).getTaxIncentivesType(), detail.getTaxIncentivesType())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4\uff0c\u6298\u6263\u884c\u4e3a\u3010%s\u3011\uff0c\u539f\u53d1\u7968\u884c\u4e3a\u3010%s\u3011", i + 1, detail.getTaxIncentivesType(), detailList.get(i - 1).getTaxIncentivesType())));
            }
            detailTotalAmount = detailTotalAmount.add(detail.getAmountWithTax());
            detailTotalTaxAmount = detailTotalTaxAmount.add(detail.getAmountWithoutTax().multiply(detail.getTaxRate()));
        }
        if (detailTotalAmount.subtract(invoiceTotalAmount).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(0.01)) > 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u660e\u7ec6\u884c\u5408\u8ba1\u91d1\u989d\u6700\u5927\u8bef\u5dee\u9700\u5c0f\u4e8e\u7b49\u4e8e0.01\u5143\uff0c\u4f20\u5165\u503c\u4e3a\u3010|%s-%s|>0.01\u3011", detailTotalAmount, invoiceTotalAmount)));
        }
        if (detailTotalTaxAmount.subtract(invoiceTotalTaxAmount).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(1.27)) > 0) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u660e\u7ec6\u884c\u5408\u8ba1\u7a0e\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee1.27\u5143\uff0c\u3010|%s-%s|>1.27\u3011", detailTotalTaxAmount.setScale(2, RoundingMode.HALF_UP), invoiceTotalTaxAmount)));
        }
        return result;
    }

    public BaseInvoiceInfo getInvoiceBaseInfo() {
        return this.invoiceBaseInfo;
    }

    public SellerInfo getSellerInfo() {
        return this.sellerInfo;
    }

    public BuyerInfo getBuyerInfo() {
        return this.buyerInfo;
    }

    public NatureInfo getNatureInfo() {
        return this.natureInfo;
    }

    public InvoiceAmountInfo getInvoiceAmountInfo() {
        return this.invoiceAmountInfo;
    }

    public OperatorInfo getOperatorInfo() {
        return this.operatorInfo;
    }

    public RedLetterInfo getRedLetterInfo() {
        return this.redLetterInfo;
    }

    public List<InvoiceDetail> getInvoiceDetailList() {
        return this.invoiceDetailList;
    }

    public void setInvoiceBaseInfo(BaseInvoiceInfo invoiceBaseInfo) {
        this.invoiceBaseInfo = invoiceBaseInfo;
    }

    public void setSellerInfo(SellerInfo sellerInfo) {
        this.sellerInfo = sellerInfo;
    }

    public void setBuyerInfo(BuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public void setNatureInfo(NatureInfo natureInfo) {
        this.natureInfo = natureInfo;
    }

    public void setInvoiceAmountInfo(InvoiceAmountInfo invoiceAmountInfo) {
        this.invoiceAmountInfo = invoiceAmountInfo;
    }

    public void setOperatorInfo(OperatorInfo operatorInfo) {
        this.operatorInfo = operatorInfo;
    }

    public void setRedLetterInfo(RedLetterInfo redLetterInfo) {
        this.redLetterInfo = redLetterInfo;
    }

    public void setInvoiceDetailList(List<InvoiceDetail> invoiceDetailList) {
        this.invoiceDetailList = invoiceDetailList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceBaseValidator)) {
            return false;
        }
        InvoiceBaseValidator other = (InvoiceBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseInvoiceInfo this$invoiceBaseInfo = this.getInvoiceBaseInfo();
        BaseInvoiceInfo other$invoiceBaseInfo = other.getInvoiceBaseInfo();
        if (this$invoiceBaseInfo == null ? other$invoiceBaseInfo != null : !((Object)this$invoiceBaseInfo).equals(other$invoiceBaseInfo)) {
            return false;
        }
        SellerInfo this$sellerInfo = this.getSellerInfo();
        SellerInfo other$sellerInfo = other.getSellerInfo();
        if (this$sellerInfo == null ? other$sellerInfo != null : !((Object)this$sellerInfo).equals(other$sellerInfo)) {
            return false;
        }
        BuyerInfo this$buyerInfo = this.getBuyerInfo();
        BuyerInfo other$buyerInfo = other.getBuyerInfo();
        if (this$buyerInfo == null ? other$buyerInfo != null : !((Object)this$buyerInfo).equals(other$buyerInfo)) {
            return false;
        }
        NatureInfo this$natureInfo = this.getNatureInfo();
        NatureInfo other$natureInfo = other.getNatureInfo();
        if (this$natureInfo == null ? other$natureInfo != null : !((Object)this$natureInfo).equals(other$natureInfo)) {
            return false;
        }
        InvoiceAmountInfo this$invoiceAmountInfo = this.getInvoiceAmountInfo();
        InvoiceAmountInfo other$invoiceAmountInfo = other.getInvoiceAmountInfo();
        if (this$invoiceAmountInfo == null ? other$invoiceAmountInfo != null : !((Object)this$invoiceAmountInfo).equals(other$invoiceAmountInfo)) {
            return false;
        }
        OperatorInfo this$operatorInfo = this.getOperatorInfo();
        OperatorInfo other$operatorInfo = other.getOperatorInfo();
        if (this$operatorInfo == null ? other$operatorInfo != null : !((Object)this$operatorInfo).equals(other$operatorInfo)) {
            return false;
        }
        RedLetterInfo this$redLetterInfo = this.getRedLetterInfo();
        RedLetterInfo other$redLetterInfo = other.getRedLetterInfo();
        if (this$redLetterInfo == null ? other$redLetterInfo != null : !((Object)this$redLetterInfo).equals(other$redLetterInfo)) {
            return false;
        }
        List<InvoiceDetail> this$invoiceDetailList = this.getInvoiceDetailList();
        List<InvoiceDetail> other$invoiceDetailList = other.getInvoiceDetailList();
        return !(this$invoiceDetailList == null ? other$invoiceDetailList != null : !((Object)this$invoiceDetailList).equals(other$invoiceDetailList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoiceBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseInvoiceInfo $invoiceBaseInfo = this.getInvoiceBaseInfo();
        result = result * 59 + ($invoiceBaseInfo == null ? 43 : ((Object)$invoiceBaseInfo).hashCode());
        SellerInfo $sellerInfo = this.getSellerInfo();
        result = result * 59 + ($sellerInfo == null ? 43 : ((Object)$sellerInfo).hashCode());
        BuyerInfo $buyerInfo = this.getBuyerInfo();
        result = result * 59 + ($buyerInfo == null ? 43 : ((Object)$buyerInfo).hashCode());
        NatureInfo $natureInfo = this.getNatureInfo();
        result = result * 59 + ($natureInfo == null ? 43 : ((Object)$natureInfo).hashCode());
        InvoiceAmountInfo $invoiceAmountInfo = this.getInvoiceAmountInfo();
        result = result * 59 + ($invoiceAmountInfo == null ? 43 : ((Object)$invoiceAmountInfo).hashCode());
        OperatorInfo $operatorInfo = this.getOperatorInfo();
        result = result * 59 + ($operatorInfo == null ? 43 : ((Object)$operatorInfo).hashCode());
        RedLetterInfo $redLetterInfo = this.getRedLetterInfo();
        result = result * 59 + ($redLetterInfo == null ? 43 : ((Object)$redLetterInfo).hashCode());
        List<InvoiceDetail> $invoiceDetailList = this.getInvoiceDetailList();
        result = result * 59 + ($invoiceDetailList == null ? 43 : ((Object)$invoiceDetailList).hashCode());
        return result;
    }

    public String toString() {
        return "InvoiceBaseValidator(invoiceBaseInfo=" + this.getInvoiceBaseInfo() + ", sellerInfo=" + this.getSellerInfo() + ", buyerInfo=" + this.getBuyerInfo() + ", natureInfo=" + this.getNatureInfo() + ", invoiceAmountInfo=" + this.getInvoiceAmountInfo() + ", operatorInfo=" + this.getOperatorInfo() + ", redLetterInfo=" + this.getRedLetterInfo() + ", invoiceDetailList=" + this.getInvoiceDetailList() + ")";
    }

    public static class Additional {
        @Alias(value="\u9644\u52a0\u8981\u7d20\u540d\u79f0")
        @Length(max=200)
        @JSONField(name="fjysmc")
        private @Length(max=200) String additionalElementName;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u7c7b\u578b")
        @Length(max=200)
        @JSONField(name="fjyslx")
        private @Length(max=200) String additionalElementType;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u503c")
        @Length(max=200)
        @JSONField(name="fjysz")
        private @Length(max=200) String additionalElementValue;

        public String getAdditionalElementName() {
            return this.additionalElementName;
        }

        public String getAdditionalElementType() {
            return this.additionalElementType;
        }

        public String getAdditionalElementValue() {
            return this.additionalElementValue;
        }

        public void setAdditionalElementName(String additionalElementName) {
            this.additionalElementName = additionalElementName;
        }

        public void setAdditionalElementType(String additionalElementType) {
            this.additionalElementType = additionalElementType;
        }

        public void setAdditionalElementValue(String additionalElementValue) {
            this.additionalElementValue = additionalElementValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Additional)) {
                return false;
            }
            Additional other = (Additional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$additionalElementName = this.getAdditionalElementName();
            String other$additionalElementName = other.getAdditionalElementName();
            if (this$additionalElementName == null ? other$additionalElementName != null : !this$additionalElementName.equals(other$additionalElementName)) {
                return false;
            }
            String this$additionalElementType = this.getAdditionalElementType();
            String other$additionalElementType = other.getAdditionalElementType();
            if (this$additionalElementType == null ? other$additionalElementType != null : !this$additionalElementType.equals(other$additionalElementType)) {
                return false;
            }
            String this$additionalElementValue = this.getAdditionalElementValue();
            String other$additionalElementValue = other.getAdditionalElementValue();
            return !(this$additionalElementValue == null ? other$additionalElementValue != null : !this$additionalElementValue.equals(other$additionalElementValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Additional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $additionalElementName = this.getAdditionalElementName();
            result = result * 59 + ($additionalElementName == null ? 43 : $additionalElementName.hashCode());
            String $additionalElementType = this.getAdditionalElementType();
            result = result * 59 + ($additionalElementType == null ? 43 : $additionalElementType.hashCode());
            String $additionalElementValue = this.getAdditionalElementValue();
            result = result * 59 + ($additionalElementValue == null ? 43 : $additionalElementValue.hashCode());
            return result;
        }

        public String toString() {
            return "InvoiceBaseValidator.Additional(additionalElementName=" + this.getAdditionalElementName() + ", additionalElementType=" + this.getAdditionalElementType() + ", additionalElementValue=" + this.getAdditionalElementValue() + ")";
        }
    }

    public static class InvoiceDetail
    extends BaseDetail {
        @Alias(value="\u542b\u7a0e\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="hsje")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;
        @Alias(value="\u6263\u9664\u989d")
        @Digits(integer=18, fraction=2)
        @JSONField(name="kce")
        private @Digits(integer=18, fraction=2) BigDecimal deduction;
        @Alias(value="\u53d1\u7968\u884c\u6027\u8d28")
        @NotEmpty
        @Length(max=2)
        @Pattern(regexp="0[0-2]")
        @JSONField(name="fphxz")
        private @NotEmpty @Length(max=2) @Pattern(regexp="0[0-2]") String discountType;
        @Alias(value="\u4f18\u60e0\u653f\u7b56\u6807\u8bc6")
        @Pattern(regexp="^$|0[1-9]|1[0-8]")
        @JSONField(name="yhzcbs")
        private @Pattern(regexp="^$|0[1-9]|1[0-8]") String taxIncentivesType;

        ValidateResult validateData() {
            ValidateResult result = ValidateResult.success();
            result = BasicValidator.mergeValidateResult(result, this.isValidAmount());
            result = BasicValidator.mergeValidateResult(result, this.isValidTaxAmount());
            return result;
        }

        private ValidateResult isValidAmount() {
            BigDecimal quantity;
            if (StringUtils.isBlank((CharSequence)this.getUnitPrice()) || StringUtils.isBlank((CharSequence)this.getQuantity())) {
                return ValidateResult.success();
            }
            BigDecimal unitPrice = new BigDecimal(this.getUnitPrice());
            if (unitPrice.multiply(quantity = new BigDecimal(this.getQuantity())).subtract(this.getAmountWithoutTax()).abs().setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(0.01)) > 0) {
                return ValidateResult.fail(String.format("\u5355\u884c\u91d1\u989d\u6700\u5927\u8bef\u5dee\u9700\u5c0f\u4e8e\u7b49\u4e8e0.01\uff0c\u4f20\u5165\u503c\u4e3a\u3010|%s*%s-%s|>0.01\u3011", this.getQuantity(), this.getUnitPrice(), this.getAmountWithoutTax()));
            }
            return ValidateResult.success();
        }

        private ValidateResult isValidTaxAmount() {
            if (this.getAmountWithoutTax().multiply(this.getTaxRate()).subtract(this.getTaxAmount()).abs().compareTo(BigDecimal.valueOf(0.06)) > 0) {
                return ValidateResult.fail(String.format("\u5355\u884c\u7a0e\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e0.06\uff0c\u4f20\u5165\u503c\u4e3a\u3010|%s*%s-%s|>0.06\u3011", this.getAmountWithoutTax(), this.getTaxRate(), this.getTaxAmount()));
            }
            return ValidateResult.success();
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        public BigDecimal getDeduction() {
            return this.deduction;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        @Override
        public String getTaxIncentivesType() {
            return this.taxIncentivesType;
        }

        public void setAmountWithTax(BigDecimal amountWithTax) {
            this.amountWithTax = amountWithTax;
        }

        public void setDeduction(BigDecimal deduction) {
            this.deduction = deduction;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        @Override
        public void setTaxIncentivesType(String taxIncentivesType) {
            this.taxIncentivesType = taxIncentivesType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceDetail)) {
                return false;
            }
            InvoiceDetail other = (InvoiceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$amountWithTax = this.getAmountWithTax();
            BigDecimal other$amountWithTax = other.getAmountWithTax();
            if (this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax)) {
                return false;
            }
            BigDecimal this$deduction = this.getDeduction();
            BigDecimal other$deduction = other.getDeduction();
            if (this$deduction == null ? other$deduction != null : !((Object)this$deduction).equals(other$deduction)) {
                return false;
            }
            String this$discountType = this.getDiscountType();
            String other$discountType = other.getDiscountType();
            if (this$discountType == null ? other$discountType != null : !this$discountType.equals(other$discountType)) {
                return false;
            }
            String this$taxIncentivesType = this.getTaxIncentivesType();
            String other$taxIncentivesType = other.getTaxIncentivesType();
            return !(this$taxIncentivesType == null ? other$taxIncentivesType != null : !this$taxIncentivesType.equals(other$taxIncentivesType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceDetail;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $amountWithTax = this.getAmountWithTax();
            result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
            BigDecimal $deduction = this.getDeduction();
            result = result * 59 + ($deduction == null ? 43 : ((Object)$deduction).hashCode());
            String $discountType = this.getDiscountType();
            result = result * 59 + ($discountType == null ? 43 : $discountType.hashCode());
            String $taxIncentivesType = this.getTaxIncentivesType();
            result = result * 59 + ($taxIncentivesType == null ? 43 : $taxIncentivesType.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "InvoiceBaseValidator.InvoiceDetail(amountWithTax=" + this.getAmountWithTax() + ", deduction=" + this.getDeduction() + ", discountType=" + this.getDiscountType() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ")";
        }
    }
}

