/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.check.model.util.CommonUtil;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.CapabilityCodeEnum;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class JewelryBaseValidator {
    private List<String> goodsTaxNoList = List.of("1060509010000000000", "1060509020100000000", "1060509020200000000");
    private String sellerTaxNo;
    private boolean sellerJewelryPilotFlag = false;
    private boolean sellerJewelryQualificationFlag = false;
    private String buyerTaxNo;
    private String buyerName;
    private boolean buyerNatureFlag = false;
    private boolean buyerJewelryPilotFlag = false;
    private boolean buyerJewelryQualificationFlag = false;
    private boolean isRed;
    private List<Detail> detailList;
    private List<String> capabilityCodeList;
    private String invoiceStyleType;

    public ValidateResult validate() {
        ValidateResult result = ValidateResult.success();
        if (this.detailList == null || this.detailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u91d1\u94f6\u9996\u9970\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("26") && !this.getCapabilityCodeList().contains("27")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8bf7\u524d\u5f80\u7535\u5b50\u7a0e\u5c40\u201c\u4e50\u4f01\u6570\u5b57\u5f00\u653e\u5e73\u53f0\u201d\u68c0\u67e5\u6240\u4f7f\u7528\u7684[%s]\u662f\u5426\u5df2\u88ab\u6388\u6743\u9080\u8bf7", CapabilityCodeEnum.fromCode((String)"26").toDesc())));
            return result;
        }
        for (Detail detail : this.detailList) {
            ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
            result = BasicValidator.mergeValidateResult(result, validateResult);
            if (this.isRed() || this.goodsTaxNoList.contains(detail.getGoodsTaxNo())) continue;
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u660e\u7ec6\uff0c\u5f00\u5177\u91d1\u94f6\u9996\u9970\u53d1\u7968\u65f6\uff0c\u53ea\u80fd\u4f7f\u7528\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u30101060509010000000000,1060509020100000000,1060509020200000000\u3011\uff0c\u8bf7\u68c0\u67e5\u3002\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", detail.getRowNum(), detail.getGoodsTaxNo())));
            return result;
        }
        return result;
    }

    public ValidateResult validateJewelryCapabilityCode() {
        ValidateResult result = ValidateResult.success();
        if (this.isSellerJewelryPilotFlag() && this.isBuyerJewelryPilotFlag()) {
            if (this.isSellerJewelryQualificationFlag() && this.isBuyerJewelryQualificationFlag()) {
                if ("26".equals(this.invoiceStyleType) || "27".equals(this.invoiceStyleType)) {
                    return result;
                }
                return BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u9700\u5f00\u5177\u91d1\u94f6\u9996\u9970\u7279\u6b8a\u4e1a\u52a1\u53d1\u7968\uff0c\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\u4f20\u5165\u503c\u4e3a\u7a7a%s\uff0c\u5e94\u4e3a\uff1a\u301026-\u91d1\u94f6\u9996\u9970\u6279\u53d1\u621627-\u91d1\u94f6\u9996\u9970\u96f6\u552e\u3011", CommonUtil.cleanBlankString(this.getInvoiceStyleType()))));
            }
            if (this.isSellerJewelryQualificationFlag() && !this.isBuyerJewelryQualificationFlag() || !this.isSellerJewelryQualificationFlag() && this.isBuyerJewelryQualificationFlag() || !this.isSellerJewelryQualificationFlag() && !this.isBuyerJewelryQualificationFlag()) {
                if ("27".equals(this.invoiceStyleType)) {
                    return result;
                }
                return BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u91d1\u94f6\u9996\u9970\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\u4e0d\u5408\u6cd5\u3002\u4f20\u5165\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\uff1a\u3010%s\u3011\uff0c\u5e94\u4e3a\uff1a\u301027-\u91d1\u94f6\u9996\u9970\u96f6\u552e\u3011", CommonUtil.cleanBlankString(this.getInvoiceStyleType()))));
            }
        }
        if (this.isSellerJewelryPilotFlag() && this.isBuyerNatureFlag()) {
            if ("27".equals(this.invoiceStyleType)) {
                return result;
            }
            return BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u91d1\u94f6\u9996\u9970\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\u4e0d\u5408\u6cd5\u3002\u4f20\u5165\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\uff1a\u3010%s\u3011\uff0c\u5e94\u4e3a\uff1a\u301027-\u91d1\u94f6\u9996\u9970\u96f6\u552e\u3011", CommonUtil.cleanBlankString(this.getInvoiceStyleType()))));
        }
        if (StringUtils.isEmpty((CharSequence)this.invoiceStyleType)) {
            return result;
        }
        return BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u4e0d\u80fd\u5f00\u5177\u91d1\u94f6\u9996\u9970\u7279\u6b8a\u4e1a\u52a1\u53d1\u7968\uff0c\u8bf7\u5f00\u5177\u975e\u7279\u6b8a\u4e1a\u52a1\u7684\u53d1\u7968\u3002\u4f20\u5165\u7279\u6b8a\u4e1a\u52a1\u4ee3\u7801\uff1a\u3010%s\u3011\uff0c\u5e94\u4e3a\u7a7a", CommonUtil.cleanBlankString(this.getInvoiceStyleType()))));
    }

    public List<String> getGoodsTaxNoList() {
        return this.goodsTaxNoList;
    }

    public String getSellerTaxNo() {
        return this.sellerTaxNo;
    }

    public boolean isSellerJewelryPilotFlag() {
        return this.sellerJewelryPilotFlag;
    }

    public boolean isSellerJewelryQualificationFlag() {
        return this.sellerJewelryQualificationFlag;
    }

    public String getBuyerTaxNo() {
        return this.buyerTaxNo;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public boolean isBuyerNatureFlag() {
        return this.buyerNatureFlag;
    }

    public boolean isBuyerJewelryPilotFlag() {
        return this.buyerJewelryPilotFlag;
    }

    public boolean isBuyerJewelryQualificationFlag() {
        return this.buyerJewelryQualificationFlag;
    }

    public boolean isRed() {
        return this.isRed;
    }

    public List<Detail> getDetailList() {
        return this.detailList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public String getInvoiceStyleType() {
        return this.invoiceStyleType;
    }

    public void setGoodsTaxNoList(List<String> goodsTaxNoList) {
        this.goodsTaxNoList = goodsTaxNoList;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public void setSellerJewelryPilotFlag(boolean sellerJewelryPilotFlag) {
        this.sellerJewelryPilotFlag = sellerJewelryPilotFlag;
    }

    public void setSellerJewelryQualificationFlag(boolean sellerJewelryQualificationFlag) {
        this.sellerJewelryQualificationFlag = sellerJewelryQualificationFlag;
    }

    public void setBuyerTaxNo(String buyerTaxNo) {
        this.buyerTaxNo = buyerTaxNo;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public void setBuyerNatureFlag(boolean buyerNatureFlag) {
        this.buyerNatureFlag = buyerNatureFlag;
    }

    public void setBuyerJewelryPilotFlag(boolean buyerJewelryPilotFlag) {
        this.buyerJewelryPilotFlag = buyerJewelryPilotFlag;
    }

    public void setBuyerJewelryQualificationFlag(boolean buyerJewelryQualificationFlag) {
        this.buyerJewelryQualificationFlag = buyerJewelryQualificationFlag;
    }

    public void setRed(boolean isRed) {
        this.isRed = isRed;
    }

    public void setDetailList(List<Detail> detailList) {
        this.detailList = detailList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public void setInvoiceStyleType(String invoiceStyleType) {
        this.invoiceStyleType = invoiceStyleType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JewelryBaseValidator)) {
            return false;
        }
        JewelryBaseValidator other = (JewelryBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$goodsTaxNoList = this.getGoodsTaxNoList();
        List<String> other$goodsTaxNoList = other.getGoodsTaxNoList();
        if (this$goodsTaxNoList == null ? other$goodsTaxNoList != null : !((Object)this$goodsTaxNoList).equals(other$goodsTaxNoList)) {
            return false;
        }
        String this$sellerTaxNo = this.getSellerTaxNo();
        String other$sellerTaxNo = other.getSellerTaxNo();
        if (this$sellerTaxNo == null ? other$sellerTaxNo != null : !this$sellerTaxNo.equals(other$sellerTaxNo)) {
            return false;
        }
        if (this.isSellerJewelryPilotFlag() != other.isSellerJewelryPilotFlag()) {
            return false;
        }
        if (this.isSellerJewelryQualificationFlag() != other.isSellerJewelryQualificationFlag()) {
            return false;
        }
        String this$buyerTaxNo = this.getBuyerTaxNo();
        String other$buyerTaxNo = other.getBuyerTaxNo();
        if (this$buyerTaxNo == null ? other$buyerTaxNo != null : !this$buyerTaxNo.equals(other$buyerTaxNo)) {
            return false;
        }
        String this$buyerName = this.getBuyerName();
        String other$buyerName = other.getBuyerName();
        if (this$buyerName == null ? other$buyerName != null : !this$buyerName.equals(other$buyerName)) {
            return false;
        }
        if (this.isBuyerNatureFlag() != other.isBuyerNatureFlag()) {
            return false;
        }
        if (this.isBuyerJewelryPilotFlag() != other.isBuyerJewelryPilotFlag()) {
            return false;
        }
        if (this.isBuyerJewelryQualificationFlag() != other.isBuyerJewelryQualificationFlag()) {
            return false;
        }
        if (this.isRed() != other.isRed()) {
            return false;
        }
        List<Detail> this$detailList = this.getDetailList();
        List<Detail> other$detailList = other.getDetailList();
        if (this$detailList == null ? other$detailList != null : !((Object)this$detailList).equals(other$detailList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        if (this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList)) {
            return false;
        }
        String this$invoiceStyleType = this.getInvoiceStyleType();
        String other$invoiceStyleType = other.getInvoiceStyleType();
        return !(this$invoiceStyleType == null ? other$invoiceStyleType != null : !this$invoiceStyleType.equals(other$invoiceStyleType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JewelryBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $goodsTaxNoList = this.getGoodsTaxNoList();
        result = result * 59 + ($goodsTaxNoList == null ? 43 : ((Object)$goodsTaxNoList).hashCode());
        String $sellerTaxNo = this.getSellerTaxNo();
        result = result * 59 + ($sellerTaxNo == null ? 43 : $sellerTaxNo.hashCode());
        result = result * 59 + (this.isSellerJewelryPilotFlag() ? 79 : 97);
        result = result * 59 + (this.isSellerJewelryQualificationFlag() ? 79 : 97);
        String $buyerTaxNo = this.getBuyerTaxNo();
        result = result * 59 + ($buyerTaxNo == null ? 43 : $buyerTaxNo.hashCode());
        String $buyerName = this.getBuyerName();
        result = result * 59 + ($buyerName == null ? 43 : $buyerName.hashCode());
        result = result * 59 + (this.isBuyerNatureFlag() ? 79 : 97);
        result = result * 59 + (this.isBuyerJewelryPilotFlag() ? 79 : 97);
        result = result * 59 + (this.isBuyerJewelryQualificationFlag() ? 79 : 97);
        result = result * 59 + (this.isRed() ? 79 : 97);
        List<Detail> $detailList = this.getDetailList();
        result = result * 59 + ($detailList == null ? 43 : ((Object)$detailList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        String $invoiceStyleType = this.getInvoiceStyleType();
        result = result * 59 + ($invoiceStyleType == null ? 43 : $invoiceStyleType.hashCode());
        return result;
    }

    public String toString() {
        return "JewelryBaseValidator(goodsTaxNoList=" + this.getGoodsTaxNoList() + ", sellerTaxNo=" + this.getSellerTaxNo() + ", sellerJewelryPilotFlag=" + this.isSellerJewelryPilotFlag() + ", sellerJewelryQualificationFlag=" + this.isSellerJewelryQualificationFlag() + ", buyerTaxNo=" + this.getBuyerTaxNo() + ", buyerName=" + this.getBuyerName() + ", buyerNatureFlag=" + this.isBuyerNatureFlag() + ", buyerJewelryPilotFlag=" + this.isBuyerJewelryPilotFlag() + ", buyerJewelryQualificationFlag=" + this.isBuyerJewelryQualificationFlag() + ", isRed=" + this.isRed() + ", detailList=" + this.getDetailList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ", invoiceStyleType=" + this.getInvoiceStyleType() + ")";
    }

    public static class Detail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u91d1\u94f6\u9996\u9970\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            return !(this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            return result;
        }

        public String toString() {
            return "JewelryBaseValidator.Detail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ")";
        }
    }
}

