/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import com.google.common.collect.Lists;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.InvoiceStyleTypeGoodsTaxNoProvider;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.constant.AreaUnitEnum;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.CapabilityCodeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class RealEstateSalesBaseValidator {
    private static final List<String> realEstatePlaceKeyWord = Arrays.asList("\u8857", "\u8def", "\u6751", "\u4e61", "\u9547", "\u9053", "\u5df7", "\u53f7");
    @Alias(value="\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u5217\u8868")
    private List<RealEstateSalesDetail> realEstateSalesDetailList;
    private List<RealEstateSalesInfo> realEstateSalesInfoList;
    private List<String> capabilityCodeList;

    public ValidateResult validate() {
        ValidateResult result = BasicValidator.validate(this);
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getRealEstateSalesInfoList()));
        result = BasicValidator.mergeValidateResult(result, BasicValidator.validate(this.getRealEstateSalesDetailList()));
        if (this.realEstateSalesDetailList == null || this.realEstateSalesDetailList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u5217\u8868\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateSalesInfoList == null || this.realEstateSalesInfoList.isEmpty()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u4e0d\u52a8\u4ea7\u9500\u552e\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            return result;
        }
        if (this.realEstateSalesInfoList.size() != this.realEstateSalesDetailList.size()) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u4e0d\u52a8\u4ea7\u9500\u552e\u53d1\u7968\u660e\u7ec6\u884c\uff08\u88ab\u6298\u6263\u884c\u4e0e\u6298\u6263\u884c\u89c6\u4e3a1\u884c\uff09\u6570\u91cf\u9700\u8981\u4e0e\u7279\u5b9a\u8981\u7d20\u4fe1\u606f\u6570\u91cf\u4fdd\u6301\u4e00\u81f4\u3002\u53d1\u7968\u660e\u7ec6\u884c\u6570\u4e3a\u3010%s\u3011\uff0c\u7279\u5b9a\u8981\u7d20\u4fe1\u606f\u884c\u6570\u4e3a\u3010%s\u3011", this.realEstateSalesDetailList.size(), this.realEstateSalesInfoList.size())));
            return result;
        }
        for (RealEstateSalesInfo realEstateSalesInfo : this.realEstateSalesInfoList) {
            if (StringUtils.isBlank((CharSequence)realEstateSalesInfo.getRealEstatePlace()) || realEstatePlaceKeyWord.stream().noneMatch(x -> realEstateSalesInfo.getRealEstatePlace().contains((CharSequence)x))) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c\u4e0d\u52a8\u4ea7\u5730\u5740\u5fc5\u987b\u5305\u542b\u8857\u3001\u8def\u3001\u6751\u3001\u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u7b49\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd\u3002\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", realEstateSalesInfo.getRowNum(), realEstateSalesInfo)));
                return result;
            }
            ArrayList specialProviceList = Lists.newArrayList((Object[])new String[]{"\u53f0\u6e7e\u7701", "\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a", "\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a"});
            if (specialProviceList.stream().noneMatch(specialProvice -> Objects.equals(realEstateSalesInfo.getRealEstateProvince(), specialProvice)) && StringUtils.isBlank((CharSequence)realEstateSalesInfo.getRealEstateCity())) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c \u5f53\u201c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09\u201d\u4e3a\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a\u3001\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a\u3001\u53f0\u6e7e\u7701\u65f6\uff0c\u201c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u5e02\uff09\u201d\u53ef\u4e3a\u7a7a\uff0c\u5176\u4ed6\u60c5\u51b5\u5fc5\u586b\u3002", realEstateSalesInfo.getRowNum())));
                return result;
            }
            if (realEstateSalesInfo.getRealEstatePlace().length() > 80) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u8be6\u7ec6\u5730\u5740\uff09\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc780\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011\uff0c\u957f\u5ea6\u4e3a\u3010%s\u3011", realEstateSalesInfo.getRowNum(), realEstateSalesInfo.getRealEstatePlace(), realEstateSalesInfo.getRealEstatePlace().length())));
                return result;
            }
            if (realEstateSalesInfo.getCrossCitySign() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", realEstateSalesInfo.getRowNum())));
                return result;
            }
            if (realEstateSalesInfo.getAreaUnit() == null) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c\u9762\u79ef\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", realEstateSalesInfo.getRowNum())));
                return result;
            }
            if (realEstateSalesInfo.getTaxablePrice() == null || realEstateSalesInfo.getTransactionPrice() != null) continue;
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%d\u884c\u4e0d\u52a8\u4ea7\u9500\u552e\u7279\u5b9a\u8981\u7d20\u5217\u8868\uff0c\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d\u82e5\u6309\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c\u5f81\u7a0e\u7684\uff0c\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d\u5fc5\u586b\u3002", realEstateSalesInfo.getRowNum())));
            return result;
        }
        List provinceList = this.realEstateSalesInfoList.stream().map(RealEstateSalesInfo::getRealEstateProvince).distinct().collect(Collectors.toList());
        if (provinceList.size() > 1) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5f00\u5177\u591a\u884c\u53d1\u7968\u660e\u7ec6\u65f6\uff0c\u6bcf\u884c\u53d1\u7968\u660e\u7ec6\u201c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09[%s]\u201d\u5fc5\u987b\u76f8\u540c\u3002", StringUtils.join(provinceList, (String)","))));
            return result;
        }
        if (CollectionUtils.isEmpty(this.getCapabilityCodeList()) || !this.getCapabilityCodeList().contains("05")) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u8bf7\u524d\u5f80\u7535\u5b50\u7a0e\u5c40\u201c\u4e50\u4f01\u6570\u5b57\u5f00\u653e\u5e73\u53f0\u201d\u68c0\u67e5\u6240\u4f7f\u7528\u7684[%s]\u662f\u5426\u5df2\u88ab\u6388\u6743\u9080\u8bf7", CapabilityCodeEnum.fromCode((String)"05").toDesc())));
            return result;
        }
        return result;
    }

    public ValidateResult validateRealEstateSalesData(InvoiceStyleTypeGoodsTaxNoProvider provider) {
        ValidateResult result = ValidateResult.success();
        RealEstateSalesDetail realEstateSalesDetail = this.getRealEstateSalesDetailList().get(0);
        List<String> realEstateSalesGoodTaxNoList = provider.provideGoodsTaxNo();
        if (!realEstateSalesGoodTaxNoList.contains(realEstateSalesDetail.getGoodsTaxNo())) {
            result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u5f00\u5177\u53d1\u7968\u65f6\uff0c\u4f7f\u7528\u7684\u5546\u54c1\u7f16\u7801\u5e94\u4e3a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e2d\u4e0d\u52a8\u4ea7\u9500\u552e\u7c7b\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\uff0c\u4f20\u5165\u503c\u4e3a\u3010%s\u3011", realEstateSalesDetail.getGoodsTaxNo())));
            return result;
        }
        return result;
    }

    public List<RealEstateSalesDetail> getRealEstateSalesDetailList() {
        return this.realEstateSalesDetailList;
    }

    public List<RealEstateSalesInfo> getRealEstateSalesInfoList() {
        return this.realEstateSalesInfoList;
    }

    public List<String> getCapabilityCodeList() {
        return this.capabilityCodeList;
    }

    public void setRealEstateSalesDetailList(List<RealEstateSalesDetail> realEstateSalesDetailList) {
        this.realEstateSalesDetailList = realEstateSalesDetailList;
    }

    public void setRealEstateSalesInfoList(List<RealEstateSalesInfo> realEstateSalesInfoList) {
        this.realEstateSalesInfoList = realEstateSalesInfoList;
    }

    public void setCapabilityCodeList(List<String> capabilityCodeList) {
        this.capabilityCodeList = capabilityCodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealEstateSalesBaseValidator)) {
            return false;
        }
        RealEstateSalesBaseValidator other = (RealEstateSalesBaseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RealEstateSalesDetail> this$realEstateSalesDetailList = this.getRealEstateSalesDetailList();
        List<RealEstateSalesDetail> other$realEstateSalesDetailList = other.getRealEstateSalesDetailList();
        if (this$realEstateSalesDetailList == null ? other$realEstateSalesDetailList != null : !((Object)this$realEstateSalesDetailList).equals(other$realEstateSalesDetailList)) {
            return false;
        }
        List<RealEstateSalesInfo> this$realEstateSalesInfoList = this.getRealEstateSalesInfoList();
        List<RealEstateSalesInfo> other$realEstateSalesInfoList = other.getRealEstateSalesInfoList();
        if (this$realEstateSalesInfoList == null ? other$realEstateSalesInfoList != null : !((Object)this$realEstateSalesInfoList).equals(other$realEstateSalesInfoList)) {
            return false;
        }
        List<String> this$capabilityCodeList = this.getCapabilityCodeList();
        List<String> other$capabilityCodeList = other.getCapabilityCodeList();
        return !(this$capabilityCodeList == null ? other$capabilityCodeList != null : !((Object)this$capabilityCodeList).equals(other$capabilityCodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RealEstateSalesBaseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RealEstateSalesDetail> $realEstateSalesDetailList = this.getRealEstateSalesDetailList();
        result = result * 59 + ($realEstateSalesDetailList == null ? 43 : ((Object)$realEstateSalesDetailList).hashCode());
        List<RealEstateSalesInfo> $realEstateSalesInfoList = this.getRealEstateSalesInfoList();
        result = result * 59 + ($realEstateSalesInfoList == null ? 43 : ((Object)$realEstateSalesInfoList).hashCode());
        List<String> $capabilityCodeList = this.getCapabilityCodeList();
        result = result * 59 + ($capabilityCodeList == null ? 43 : ((Object)$capabilityCodeList).hashCode());
        return result;
    }

    public String toString() {
        return "RealEstateSalesBaseValidator(realEstateSalesDetailList=" + this.getRealEstateSalesDetailList() + ", realEstateSalesInfoList=" + this.getRealEstateSalesInfoList() + ", capabilityCodeList=" + this.getCapabilityCodeList() + ")";
    }

    public static class RealEstateSalesDetail {
        @Alias(value="\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u4e0d\u52a8\u4ea7\u9500\u552e\u7a0e\u7f16")
        @NotEmpty
        @Length(max=19)
        private @NotEmpty @Length(max=19) String goodsTaxNo;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RealEstateSalesDetail)) {
                return false;
            }
            RealEstateSalesDetail other = (RealEstateSalesDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            return !(this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RealEstateSalesDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            return result;
        }

        public String toString() {
            return "RealEstateSalesBaseValidator.RealEstateSalesDetail(rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ")";
        }
    }

    public static class RealEstateSalesInfo {
        private Integer rowNum;
        @Alias(value="\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7801")
        @Length(max=40)
        private @Length(max=40) String realEstateNo;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u7701\u4efd")
        private String realEstateProvince;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u5e02")
        private String realEstateCity;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5750\u843d\u8be6\u7ec6\u5730\u5740")
        private String realEstatePlace;
        private Boolean crossCitySign;
        private AreaUnitEnum areaUnit;
        @Alias(value="\u4e0d\u52a8\u4ea7\u5355\u5143\u4ee3\u7801/\u7f51\u7b7e\u5408\u540c\u5907\u6848\u7f16\u7801")
        @Length(max=28)
        private @Length(max=28) String realEstateCode;
        @Alias(value="\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7")
        @Length(max=16)
        private @Length(max=16) String landVatItemNo;
        @Alias(value="\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c")
        @Digits(integer=18, fraction=2)
        private @Digits(integer=18, fraction=2) BigDecimal taxablePrice;
        @Alias(value="\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d")
        @Digits(integer=18, fraction=2)
        private @Digits(integer=18, fraction=2) BigDecimal transactionPrice;

        public Integer getRowNum() {
            return this.rowNum;
        }

        public String getRealEstateNo() {
            return this.realEstateNo;
        }

        public String getRealEstateProvince() {
            return this.realEstateProvince;
        }

        public String getRealEstateCity() {
            return this.realEstateCity;
        }

        public String getRealEstatePlace() {
            return this.realEstatePlace;
        }

        public Boolean getCrossCitySign() {
            return this.crossCitySign;
        }

        public AreaUnitEnum getAreaUnit() {
            return this.areaUnit;
        }

        public String getRealEstateCode() {
            return this.realEstateCode;
        }

        public String getLandVatItemNo() {
            return this.landVatItemNo;
        }

        public BigDecimal getTaxablePrice() {
            return this.taxablePrice;
        }

        public BigDecimal getTransactionPrice() {
            return this.transactionPrice;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setRealEstateNo(String realEstateNo) {
            this.realEstateNo = realEstateNo;
        }

        public void setRealEstateProvince(String realEstateProvince) {
            this.realEstateProvince = realEstateProvince;
        }

        public void setRealEstateCity(String realEstateCity) {
            this.realEstateCity = realEstateCity;
        }

        public void setRealEstatePlace(String realEstatePlace) {
            this.realEstatePlace = realEstatePlace;
        }

        public void setCrossCitySign(Boolean crossCitySign) {
            this.crossCitySign = crossCitySign;
        }

        public void setAreaUnit(AreaUnitEnum areaUnit) {
            this.areaUnit = areaUnit;
        }

        public void setRealEstateCode(String realEstateCode) {
            this.realEstateCode = realEstateCode;
        }

        public void setLandVatItemNo(String landVatItemNo) {
            this.landVatItemNo = landVatItemNo;
        }

        public void setTaxablePrice(BigDecimal taxablePrice) {
            this.taxablePrice = taxablePrice;
        }

        public void setTransactionPrice(BigDecimal transactionPrice) {
            this.transactionPrice = transactionPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RealEstateSalesInfo)) {
                return false;
            }
            RealEstateSalesInfo other = (RealEstateSalesInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            String this$realEstateNo = this.getRealEstateNo();
            String other$realEstateNo = other.getRealEstateNo();
            if (this$realEstateNo == null ? other$realEstateNo != null : !this$realEstateNo.equals(other$realEstateNo)) {
                return false;
            }
            String this$realEstateProvince = this.getRealEstateProvince();
            String other$realEstateProvince = other.getRealEstateProvince();
            if (this$realEstateProvince == null ? other$realEstateProvince != null : !this$realEstateProvince.equals(other$realEstateProvince)) {
                return false;
            }
            String this$realEstateCity = this.getRealEstateCity();
            String other$realEstateCity = other.getRealEstateCity();
            if (this$realEstateCity == null ? other$realEstateCity != null : !this$realEstateCity.equals(other$realEstateCity)) {
                return false;
            }
            String this$realEstatePlace = this.getRealEstatePlace();
            String other$realEstatePlace = other.getRealEstatePlace();
            if (this$realEstatePlace == null ? other$realEstatePlace != null : !this$realEstatePlace.equals(other$realEstatePlace)) {
                return false;
            }
            Boolean this$crossCitySign = this.getCrossCitySign();
            Boolean other$crossCitySign = other.getCrossCitySign();
            if (this$crossCitySign == null ? other$crossCitySign != null : !((Object)this$crossCitySign).equals(other$crossCitySign)) {
                return false;
            }
            AreaUnitEnum this$areaUnit = this.getAreaUnit();
            AreaUnitEnum other$areaUnit = other.getAreaUnit();
            if (this$areaUnit == null ? other$areaUnit != null : !((Object)((Object)this$areaUnit)).equals((Object)other$areaUnit)) {
                return false;
            }
            String this$realEstateCode = this.getRealEstateCode();
            String other$realEstateCode = other.getRealEstateCode();
            if (this$realEstateCode == null ? other$realEstateCode != null : !this$realEstateCode.equals(other$realEstateCode)) {
                return false;
            }
            String this$landVatItemNo = this.getLandVatItemNo();
            String other$landVatItemNo = other.getLandVatItemNo();
            if (this$landVatItemNo == null ? other$landVatItemNo != null : !this$landVatItemNo.equals(other$landVatItemNo)) {
                return false;
            }
            BigDecimal this$taxablePrice = this.getTaxablePrice();
            BigDecimal other$taxablePrice = other.getTaxablePrice();
            if (this$taxablePrice == null ? other$taxablePrice != null : !((Object)this$taxablePrice).equals(other$taxablePrice)) {
                return false;
            }
            BigDecimal this$transactionPrice = this.getTransactionPrice();
            BigDecimal other$transactionPrice = other.getTransactionPrice();
            return !(this$transactionPrice == null ? other$transactionPrice != null : !((Object)this$transactionPrice).equals(other$transactionPrice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RealEstateSalesInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            String $realEstateNo = this.getRealEstateNo();
            result = result * 59 + ($realEstateNo == null ? 43 : $realEstateNo.hashCode());
            String $realEstateProvince = this.getRealEstateProvince();
            result = result * 59 + ($realEstateProvince == null ? 43 : $realEstateProvince.hashCode());
            String $realEstateCity = this.getRealEstateCity();
            result = result * 59 + ($realEstateCity == null ? 43 : $realEstateCity.hashCode());
            String $realEstatePlace = this.getRealEstatePlace();
            result = result * 59 + ($realEstatePlace == null ? 43 : $realEstatePlace.hashCode());
            Boolean $crossCitySign = this.getCrossCitySign();
            result = result * 59 + ($crossCitySign == null ? 43 : ((Object)$crossCitySign).hashCode());
            AreaUnitEnum $areaUnit = this.getAreaUnit();
            result = result * 59 + ($areaUnit == null ? 43 : ((Object)((Object)$areaUnit)).hashCode());
            String $realEstateCode = this.getRealEstateCode();
            result = result * 59 + ($realEstateCode == null ? 43 : $realEstateCode.hashCode());
            String $landVatItemNo = this.getLandVatItemNo();
            result = result * 59 + ($landVatItemNo == null ? 43 : $landVatItemNo.hashCode());
            BigDecimal $taxablePrice = this.getTaxablePrice();
            result = result * 59 + ($taxablePrice == null ? 43 : ((Object)$taxablePrice).hashCode());
            BigDecimal $transactionPrice = this.getTransactionPrice();
            result = result * 59 + ($transactionPrice == null ? 43 : ((Object)$transactionPrice).hashCode());
            return result;
        }

        public String toString() {
            return "RealEstateSalesBaseValidator.RealEstateSalesInfo(rowNum=" + this.getRowNum() + ", realEstateNo=" + this.getRealEstateNo() + ", realEstateProvince=" + this.getRealEstateProvince() + ", realEstateCity=" + this.getRealEstateCity() + ", realEstatePlace=" + this.getRealEstatePlace() + ", crossCitySign=" + this.getCrossCitySign() + ", areaUnit=" + this.getAreaUnit() + ", realEstateCode=" + this.getRealEstateCode() + ", landVatItemNo=" + this.getLandVatItemNo() + ", taxablePrice=" + this.getTaxablePrice() + ", transactionPrice=" + this.getTransactionPrice() + ")";
        }
    }
}

