/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import cn.hutool.core.bean.BeanUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000002Exception;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.util.CommonUtil;
import com.xforceplus.taxware.chestnut.check.model.util.NumberUtil;
import com.xforceplus.taxware.chestnut.check.model.validator.invoice.InvoiceBaseValidator;
import com.xforceplus.taxware.chestnut.check.model.validator.redletter.RedLetterValidator;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RedInvoiceVsRedLetterValidator {
    public static void validate(InvoiceBaseValidator invoiceBase, RedLetterValidator redLetter) {
        if (CollectionUtils.isEmpty(invoiceBase.getInvoiceDetailList()) || CollectionUtils.isEmpty(redLetter.getDetails())) {
            throw new TXWR000002Exception("\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!invoiceBase.getInvoiceBaseInfo().getInvoiceType().equals(redLetter.getOriginalInvoiceInfo().getOriginalInvoiceType())) {
            throw new TXWR000002Exception("\u7ea2\u7968\u548c\u539f\u84dd\u7968\u53d1\u7968\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        invoiceBase.getInvoiceDetailList().sort(Comparator.comparing(BaseDetail::getRowNum));
        redLetter.getDetails().sort(Comparator.comparing(BaseDetail::getRowNum));
        RedInvoiceVsRedLetterValidator.setNull(invoiceBase, redLetter);
        for (int i = 0; i < invoiceBase.getInvoiceDetailList().size(); ++i) {
            BaseDetail invoiceDetail = invoiceBase.getInvoiceDetailList().get(i);
            BaseDetail invoiceDetailBase = new BaseDetail();
            BeanUtil.copyProperties((Object)invoiceDetail, (Object)invoiceDetailBase);
            BaseDetail redletterDetail = redLetter.getDetails().get(i);
            BaseDetail redletterDetailBase = new BaseDetail();
            BeanUtil.copyProperties((Object)redletterDetail, (Object)redletterDetailBase);
            if (!Objects.equals(invoiceDetailBase.getOriginalRowNum(), redletterDetailBase.getOriginalRowNum())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u539f\u53d1\u7968\u660e\u7ec6\u884c\u5e8f\u53f7\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[originalRowNum=%d],\u7ea2\u5b57\u786e\u8ba4\u5355[originalRowNum=%d]", i + 1, invoiceDetailBase.getOriginalRowNum(), redletterDetailBase.getOriginalRowNum()));
            }
            if (!Objects.equals(invoiceDetailBase.getRowNum(), redletterDetailBase.getRowNum())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u660e\u7ec6\u884c\u5e8f\u53f7\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[rowNum=%d],\u7ea2\u5b57\u786e\u8ba4\u5355[rowNum=%d]", i + 1, invoiceDetailBase.getRowNum(), redletterDetailBase.getRowNum()));
            }
            if (!Objects.equals(invoiceDetailBase.getGoodsTaxNo(), redletterDetailBase.getGoodsTaxNo())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u7a0e\u7f16\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[goodsTaxNo=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[goodsTaxNo=%s]", i + 1, invoiceDetailBase.getGoodsTaxNo(), redletterDetailBase.getGoodsTaxNo()));
            }
            if (!Objects.equals(invoiceDetailBase.getItemName(), redletterDetailBase.getItemName())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[itemName=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[itemName=%s]", i + 1, invoiceDetailBase.getItemName(), redletterDetailBase.getItemName()));
            }
            if (!Objects.equals(invoiceDetailBase.getUnit(), redletterDetailBase.getUnit())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u5355\u4f4d\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[unit=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[unit=%s]", i + 1, CommonUtil.cleanBlankString(invoiceDetailBase.getUnit()), CommonUtil.cleanBlankString(redletterDetailBase.getUnit())));
            }
            if (NumberUtil.isNumber(invoiceDetailBase.getUnitPrice()) && NumberUtil.isNumber(redletterDetailBase.getUnitPrice()) ? new BigDecimal(invoiceDetailBase.getUnitPrice()).compareTo(new BigDecimal(redletterDetailBase.getUnitPrice())) != 0 : !Objects.equals(invoiceDetailBase.getUnitPrice(), redletterDetailBase.getUnitPrice())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u5355\u4ef7\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[unitPrice=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[unitPrice=%s]", i + 1, invoiceDetailBase.getUnitPrice(), redletterDetailBase.getUnitPrice()));
            }
            if (NumberUtil.isNumber(invoiceDetailBase.getQuantity()) && NumberUtil.isNumber(redletterDetailBase.getQuantity()) ? new BigDecimal(invoiceDetailBase.getQuantity()).compareTo(new BigDecimal(redletterDetailBase.getQuantity())) != 0 : !Objects.equals(invoiceDetailBase.getQuantity(), redletterDetailBase.getQuantity())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u6570\u91cf\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[quantity=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[quantity=%s]", i + 1, invoiceDetailBase.getQuantity(), redletterDetailBase.getQuantity()));
            }
            if (!Objects.equals(invoiceDetailBase.getSpecifications(), redletterDetailBase.getSpecifications())) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u6570\u91cf\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[specifications=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[specifications=%s]", i + 1, invoiceDetailBase.getSpecifications(), redletterDetailBase.getSpecifications()));
            }
            if (invoiceDetailBase.getAmountWithoutTax().compareTo(redletterDetailBase.getAmountWithoutTax()) != 0) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[amountWithoutTax=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[amountWithoutTax=%s]", i + 1, invoiceDetailBase.getAmountWithoutTax(), redletterDetailBase.getAmountWithoutTax()));
            }
            if (invoiceDetailBase.getTaxRate() != null && redletterDetailBase.getTaxRate() != null && invoiceDetailBase.getTaxRate().compareTo(redletterDetailBase.getTaxRate()) != 0) {
                throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u7a0e\u7387\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[taxRate=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[taxRate=%s]", i + 1, invoiceDetailBase.getTaxRate(), redletterDetailBase.getTaxRate()));
            }
            if (invoiceDetailBase.getTaxAmount().compareTo(redletterDetailBase.getTaxAmount()) == 0) continue;
            throw new TXWR000002Exception(String.format("\u7ea2\u7968\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%s\u884c\u660e\u7ec6\u4e2d\uff0c\u7a0e\u989d\u4e0d\u76f8\u7b49\uff0c\u7ea2\u7968[taxAmount=%s],\u7ea2\u5b57\u786e\u8ba4\u5355[taxAmount=%s]", i + 1, invoiceDetailBase.getTaxAmount(), redletterDetailBase.getTaxAmount()));
        }
    }

    private static void setNull(InvoiceBaseValidator invoiceBase, RedLetterValidator redLetter) {
        invoiceBase.getInvoiceDetailList().forEach(detail -> {
            if (StringUtils.isBlank((CharSequence)detail.getSpecifications())) {
                detail.setSpecifications(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getQuantity())) {
                detail.setQuantity(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getUnit())) {
                detail.setUnit(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getUnitPrice())) {
                detail.setUnitPrice(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getGoodsTaxNo())) {
                detail.setGoodsTaxNo(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getItemName())) {
                detail.setItemName(null);
            }
        });
        redLetter.getDetails().forEach(detail -> {
            if (StringUtils.isBlank((CharSequence)detail.getSpecifications())) {
                detail.setSpecifications(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getQuantity())) {
                detail.setQuantity(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getUnit())) {
                detail.setUnit(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getUnitPrice())) {
                detail.setUnitPrice(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getGoodsTaxNo())) {
                detail.setGoodsTaxNo(null);
            }
            if (StringUtils.isBlank((CharSequence)detail.getItemName())) {
                detail.setItemName(null);
            }
        });
    }
}

