/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.taxpayer;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxpayerInfo;
import com.xforceplus.taxware.chestnut.check.model.common.RealEstateLeaseTaxPayerInfoProvider;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.SellerTaxpayerStatusEnum;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;

public class TaxpayerInfoValidator {
    public static void validate(TaxpayerInfo taxpayerInfo, @Nullable String invoiceStyleTypeCode) {
        if (taxpayerInfo == null) {
            throw new TXWR000004Exception("\u672a\u67e5\u8be2\u5230\u7eb3\u7a0e\u4eba\u57fa\u672c\u4fe1\u606f\uff0c\u7981\u6b62\u5f00\u7968");
        }
        String sellerTaxpayerStatus = taxpayerInfo.getSellerTaxpayerStatus();
        if (!SellerTaxpayerStatusEnum.SELLER_TAXPAYER_STATUS_03.getStatus().equals(sellerTaxpayerStatus) && !SellerTaxpayerStatusEnum.SELLER_TAXPAYER_STATUS_09.getStatus().equals(sellerTaxpayerStatus)) {
            throw new TXWR000004Exception(String.format("\u8be5\u7eb3\u7a0e\u4eba\u72b6\u6001\u4e3a[%s]\uff0c\u671f\u671b\u72b6\u6001\u4e3a[%s]\uff0c\u7981\u6b62\u5f00\u7968", SellerTaxpayerStatusEnum.fromStatus((String)sellerTaxpayerStatus).getStatusDesc(), "\u6b63\u5e38\u6216\u62a5\u9a8c"));
        }
        if (Objects.equals("01", invoiceStyleTypeCode) && (CollectionUtils.isEmpty(taxpayerInfo.getIndustryNaturePropertiesList()) || !taxpayerInfo.getIndustryNaturePropertiesList().contains("01") && !taxpayerInfo.getIndustryNaturePropertiesList().contains("02"))) {
            throw new TXWR000004Exception("\u975e\u6210\u54c1\u6cb9\u751f\u4ea7\u4f01\u4e1a\u3001\u6210\u54c1\u6cb9\u7ecf\u9500\u4f01\u4e1a\uff0c\u7981\u6b62\u5f00\u5177\u6210\u54c1\u6cb9\u53d1\u7968");
        }
        if (Objects.equals("16", invoiceStyleTypeCode) && (CollectionUtils.isEmpty(taxpayerInfo.getIndustryNaturePropertiesList()) || !taxpayerInfo.getIndustryNaturePropertiesList().contains("36"))) {
            throw new TXWR000004Exception("\u82e5\u5f00\u7968\u65b9\u975e\u519c\u4ea7\u54c1\u6536\u8d2d\u4f01\u4e1a\uff0c\u7981\u6b62\u5f00\u5177\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968");
        }
    }

    public static void validateRealEstateLease(TaxpayerInfo taxpayerInfo, RealEstateLeaseTaxPayerInfoProvider provider) {
        List<String> provideTaxPayerList = provider.provideTaxPayerList();
        if (provideTaxPayerList.stream().noneMatch(x -> x.equals(taxpayerInfo.getRegisterType()))) {
            throw new TXWR000004Exception("\u5f53\u4e0d\u52a8\u4ea7\u79df\u8d41\u53d1\u7968\u660e\u7ec6\u4e2d\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u201c3040502020102000000\u4e2a\u4eba\u51fa\u79df\u4f4f\u623f\u201d\u65f6\uff0c\u7eb3\u7a0e\u4eba\u5fc5\u987b\u4e3a\u4e2a\u4f53\u5de5\u5546\u6237\u6216\u81ea\u7136\u4eba\u3002\n\u4e2a\u4f53\u5de5\u5546\u6237\u6307\uff1a\u3010\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b\u3011\u4e3a\u4e2a\u4f53\u5de5\u5546\u6237\uff08\u201c410\u4e2a\u4f53\u5de5\u5546\u6237\u201d\u3001\u201c411\u5185\u8d44\u4e2a\u4f53\u201d\u3001\u201c412\u6e2f\u6fb3\u53f0\u4e2a\u4f53\u201d\u3001\u201c413\u5916\u8d44\u4e2a\u4f53\u201d\uff09\u3002\n\u81ea\u7136\u4eba\u6307\uff1a\u3010\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b\u3011\uff08\u201c430\u4e2a\u4eba\u201d\u3001\u201c431\u5185\u8d44\u4e2a\u4eba\u201d\u3001\u201c432\u6e2f\u6fb3\u53f0\u4e2a\u4eba\u201d\u3001\u201c433\u5916\u8d44\u4e2a\u4eba\u201d\uff09\u3002");
        }
    }

    public static void validateRealEstateSales(TaxpayerInfo taxpayerInfo) {
        if (CollectionUtils.isEmpty(taxpayerInfo.getIndustryNaturePropertiesList()) || !taxpayerInfo.getIndustryNaturePropertiesList().contains("31")) {
            throw new TXWR000004Exception("\u5f00\u5177\u4e0d\u52a8\u4ea7\u9500\u552e\u53d1\u7968\u65f6\uff0c\u7eb3\u7a0e\u4eba\u57fa\u7840\u4fe1\u606f\u4e2d\u7684\u4f01\u4e1a\u6027\u8d28\u4e0d\u4e3a\u201c31\uff08\u623f\u5730\u4ea7\u5f00\u53d1\u4f01\u4e1a\uff09\u201d\u7684\uff0c\u7981\u6b62\u4f7f\u7528\u524d\u4e03\u4f4d\u4e3a5010101/5010201\u7684\u7f16\u7801\u3002");
        }
    }
}

