package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信额度查询
 *
 * @author tanbenshuai
 * @date 2024-03-11 13:55
 */
public class InvoiceQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private InvoiceDto result;

        @Data
        public static class InvoiceDto {
            private String pid = "";
            private String tenantId = "";
            private String invoiceFlag = "";
            private String invoiceType = "";
            private String invoiceNo = "";
            private String invoiceDate = "";
            private String invoiceStyleType = "";
            private String vatRefundType = "";
            private Seller seller;
            private Buyer buyer;
            private Operator operator;
            private InvoiceAmount invoiceAmount;
            private RedLetter redLetter;
            private List<Details> details;
            private String remark = "";
            private Object extraList;
        }

        @Data
        public static class Seller {
            private String sellerTaxNo = "";
            private String sellerName = "";
            private String sellerAddress = "";
            private String sellerTel = "";
            private String sellerBankName = "";
            private String sellerBankAccount = "";
        }

        @Data
        public static class Buyer {
            private String buyerTaxNo = "";
            private String buyerName = "";
            private String buyerAddress = "";
            private String buyerTel = "";
            private String buyerBankName = "";
            private String buyerBankAccount = "";
            private Boolean isNature;
        }

        @Data
        public static class Operator {
            private String issuer = "";
            private String payee = "";
            private String reviewer = "";
        }

        @Data
        public static class InvoiceAmount {
            private BigDecimal amountWithoutTax;
            private BigDecimal taxAmount;
            private BigDecimal amountWithTax;
        }

        @Data
        public static class RedLetter {
            private String originalAllElectricInvoiceNo = "";
            private String originalInvoiceNo = "";
            private String originalInvoiceCode = "";
            private String redLetterNumber = "";
            private String redLetterUuid = "";
        }

        @Data
        public static class Details {
            private Integer rowNum;
            private Integer originalRowNum;
            private String discountType = "";
            private DetailAmount detailAmount;
            private Item item;
            private Tax tax;

            @Data
            public static class DetailAmount {
                private String quantity = "";
                private String unitPrice = "";
                private BigDecimal amountWithoutTax;
                private BigDecimal taxAmount;
                private BigDecimal amountWithTax;
                private BigDecimal deduction;
            }

            @Data
            public static class Item {
                private String itemName = "";
                private String specifications = "";
                private String unit = "";
            }

            @Data
            public static class Tax {
                private BigDecimal taxRate;
                private String goodsTaxNo = "";
                private String taxIncentivesType = "";
            }
        }
    }
}