package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 全电红字确认单确认
 */
public class RedLetterConfirmMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String taskId;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 统一社会信用代码/纳税人识别号/身份证件号码
         */
        private String taxNo;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 确认类型
         * Y：同意
         * N：不同意
         * C：撤销
         */
        private String confirmStatus;

        /**
         * 操作身份
         * 0: 销方
         * 1: 购方
         */
        private String confirmIdentity;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String taskId;

            /**
             * 租户id
             */
            private String tenantId;

            /**
             * 确认日期（非必须）
             * yyyy-MM-dd HH:mm:ss
             */
            private String confirmTime;
        }
    }
}
