package com.xforceplus.taxware.chestnut.contract.model.common;

import lombok.Data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * taxware-chestnut-contract
 *
 * @Author 👽 zhaolei
 * @Date 📅 2023/1/28 17:11
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description:
 */
@Data
public class ValidateResult {
    private boolean isSuccess = false;
    //    private String errorCode;
    private List<ErrorInfo> errorInfoList = new ArrayList<>();

    public static ValidateResult fail(String errorMessage) {
        return fail(null, errorMessage);
    }

    public static ValidateResult fail(String errorFieldName, String errorMessage) {
        var errorInfo = new ErrorInfo();
        errorInfo.setErrorFieldName(errorFieldName);
        errorInfo.setErrorMessage(errorMessage);
        return fail(Arrays.asList(errorInfo));
    }


    public static ValidateResult fail(List<ErrorInfo> errorInfoList) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.isSuccess = false;
        validateResult.setErrorInfoList(errorInfoList);
        return validateResult;

    }

    public static ValidateResult success() {
        ValidateResult validateResult = new ValidateResult();
        validateResult.isSuccess = true;
        return validateResult;
    }

    @Data
    public static class ErrorInfo {
        private String rowNum;
        private String errorFieldName;
        private String errorMessage;

        public ErrorInfo() {
        }

        public ErrorInfo(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

}
