package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 红字确认单状态枚举
 *
 * @author zhouwen
 * @date 2023-03-06 17:25
 */
public class RedLetter {

    public enum RedLetterStatusEnum {

        STATUS_01("01", "无需确认"),
        STATUS_02("02", "销方录入待购方确认"),
        STATUS_03("03", "购方录入待销方确认"),
        STATUS_04("04", "购销双方已确认"),
        STATUS_05("05", "作废（销方录入购方否认）"),
        STATUS_06("06", "作废（购方录入销方否认）"),
        STATUS_07("07", "作废（超72小时未确认）"),
        STATUS_08("08", "（发起方撤销）"),
        STATUS_09("09", "作废（确认后撤销）"),
        STATUS_10("10", "作废（异常凭证）")
        ;

        private final String code;
        private final String desc;

        RedLetterStatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String code() {
            return code;
        }

        public String desc() {
            return desc;
        }

        public static RedLetterStatusEnum fromCode(final String code) {
            return Arrays.stream(RedLetterStatusEnum.values())
                    .filter(e -> Objects.equals(e.code, code))
                    .findAny()
                    .orElse(null);
        }
    }

    public enum ApplyReasonEnum {

        REASON_01("01", "开票有误"),
        REASON_02("02", "销货退回"),
        REASON_03("03", "服务中止"),
        REASON_04("04", "销售折让")
        ;

        private final String code;
        private final String desc;

        ApplyReasonEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String code() {
            return code;
        }

        public String desc() {
            return desc;
        }

        public static ApplyReasonEnum fromCode(final String code) {
            return Arrays.stream(ApplyReasonEnum.values())
                    .filter(e -> Objects.equals(e.code, code))
                    .findAny()
                    .orElse(null);
        }
    }
}
