package com.xforceplus.taxware.chestnut.contract.model.util;

import com.xforceplus.taxware.chestnut.contract.model.common.Alias;
import com.xforceplus.taxware.chestnut.contract.model.common.ValidateResult;
import org.hibernate.validator.HibernateValidator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/**
 * taxware-chestnut-contract
 * <p>
 *
 * @author 👽 zhaolei
 * @date 📅 2023/1/28 17:11
 * @motto: Tools change the world. 🛠
 * @copyright: xforceplus 🇨🇳
 * @description:
 */
public class BasicValidator {

    private static final Validator validator;

    static {
        ValidatorFactory factory = Validation.byProvider(HibernateValidator.class)
                .configure()
//                .failFast(true)
                .defaultLocale(Locale.SIMPLIFIED_CHINESE)
                .buildValidatorFactory();
        validator = factory.getValidator();
    }


    public static <T> ValidateResult validate(T t) {
        return validate(t, null);
    }

    public static <T> ValidateResult validate(T t, String rowNum) {

        Set<ConstraintViolation<T>> constraintViolations;
        constraintViolations = validator.validate(t);

        if (constraintViolations.size() > 0) {
            List<ValidateResult.ErrorInfo> errorInfoList = new ArrayList<>();
            constraintViolations.forEach(next -> {
                var errorInfo = new ValidateResult.ErrorInfo();
                String filedName = getFriendlyName(next);
                String indexMessage = "";
                if (rowNum != null && rowNum.length() > 0) {
                    indexMessage = String.format("第%s行", rowNum);
                }
                errorInfo.setRowNum(rowNum);
                errorInfo.setErrorFieldName(filedName);
                errorInfo.setErrorMessage(String.format("%s%s%s", indexMessage, filedName, next.getMessage()));
                errorInfoList.add(errorInfo);
            });
            return ValidateResult.fail(errorInfoList);

        } else {
            return ValidateResult.success();
        }
    }

    private static <T> String getFriendlyName(ConstraintViolation<T> next) {
        String filedName = next.getPropertyPath().toString();
        try {
            if (filedName != null && filedName.length() > 0) {
                Alias alias = next.getRootBeanClass().getDeclaredField(next.getPropertyPath().toString()).getAnnotation(Alias.class);
                if (alias == null) {
                    return filedName;
                }
                filedName = alias.value();
            }
        } catch (Exception e) {
        }
        return filedName;
    }

    public static ValidateResult mergeValidateResult(ValidateResult v1, ValidateResult v2) {
        if (v1.isSuccess() && v2.isSuccess()) {
            return ValidateResult.success();
        }
        List<ValidateResult.ErrorInfo> errorInfoList = new ArrayList<>();
        if (v1.getErrorInfoList() != null) {
            errorInfoList.addAll(v1.getErrorInfoList());
        }
        if (v2.getErrorInfoList() != null) {
            errorInfoList.addAll(v2.getErrorInfoList());
        }
        return ValidateResult.fail(errorInfoList);
    }
}
