/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum CapabilityCodeEnum {
    COMMON("00", 1, "202007", "911001", "\u901a\u7528\u80fd\u529b"),
    OIL("01", 2, "202055", "999888", "\u6210\u54c1\u6cb9"),
    CONSTRUCTION_SERVICE("03", 4, "202044", "202206", "\u5efa\u7b51\u670d\u52a1"),
    FREIGHT_SERVICE("04", 8, "202026", "230207004", "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1"),
    REAL_ESTATE_SALES("05", 16, "202046", "202204", "\u4e0d\u52a8\u4ea7\u9500\u552e"),
    REAL_ESTATE_LEASE("06", 32, "202038", "202036", "\u4e0d\u52a8\u4ea7\u79df\u8d41"),
    PASSENGER_TRANSPORTATION("09", 64, "202027", "230207003", "\u65c5\u5ba2\u8fd0\u8f93"),
    PRODUCE_SALES("12", 128, "202031", "1234567", "\u519c\u4ea7\u54c1\u9500\u552e"),
    PRODUCE_PURCHASE("16", 256, "202019", "202019", "\u519c\u4ea7\u54c1\u6536\u8d2d"),
    PHOTOVOLTAIC_ACQUISITION("17", 512, "202017", "202017", "\u5149\u4f0f\u6536\u8d2d"),
    COLLECTION("99", 1024, "203067", "203067", "\u5f52\u96c6\u80fd\u529b"),
    DEDUCTION("100", 2048, "203065", "203065", "\u589e\u503c\u7a0e\u62b5\u6263\u52fe\u9009\u80fd\u529b"),
    TAX_REFUND_DEDUCTION("101", 4096, "203064", "203064", "\u589e\u503c\u7a0e\u9000\u7a0e\u52fe\u9009\u80fd\u529b"),
    DEPUTY_TAX_REFUND_DEDUCTION("102", 8192, "203066", "203066", "\u4ee3\u529e\u9000\u7a0e\u52fe\u9009\u80fd\u529b"),
    ENTRY("103", 16384, "203057", "203057", "\u53d1\u7968\u5165\u8d26\u80fd\u529b"),
    VERIFICATION("104", 32768, "203059", "203059", "\u53d1\u7968\u67e5\u9a8c\u80fd\u529b");

    private final String code;
    private final int numCode;
    private final String capabilityCode;
    private final String caseCode;
    private final String desc;

    private CapabilityCodeEnum(String code, int numCode, String capabilityCode, String caseCode, String desc) {
        this.code = code;
        this.numCode = numCode;
        this.capabilityCode = capabilityCode;
        this.caseCode = caseCode;
        this.desc = desc;
    }

    public String toCode() {
        return this.code;
    }

    public int toNumCode() {
        return this.numCode;
    }

    public String toCapabilityCode() {
        return this.capabilityCode;
    }

    public String toDesc() {
        return this.desc;
    }

    public String toCaseCode() {
        return this.caseCode;
    }

    public static CapabilityCodeEnum fromCode(String code) {
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> Objects.equals(x.code, code)).findAny().orElse(COMMON);
    }

    public static List<CapabilityCodeEnum> fromCodeList(List<String> codeList) {
        if (codeList == null) {
            return Arrays.asList(COMMON);
        }
        return codeList.stream().map(x -> CapabilityCodeEnum.fromCode(x)).collect(Collectors.toList());
    }

    public static List<CapabilityCodeEnum> fromNumCode(Integer numCode) {
        if (numCode == null || numCode == 0) {
            return Arrays.asList(COMMON);
        }
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> (x.numCode & numCode) > 0).collect(Collectors.toList());
    }

    public static int to(List<CapabilityCodeEnum> capabilityCodeEnums) {
        int numCode = 0;
        if (capabilityCodeEnums == null) {
            return CapabilityCodeEnum.COMMON.numCode;
        }
        for (CapabilityCodeEnum capabilityCodeEnum : capabilityCodeEnums) {
            numCode += capabilityCodeEnum.numCode;
        }
        return numCode;
    }

    public static List<String> toCodeList(List<CapabilityCodeEnum> capabilityCodeEnums) {
        if (capabilityCodeEnums == null) {
            return Arrays.asList(CapabilityCodeEnum.COMMON.code);
        }
        return capabilityCodeEnums.stream().map(CapabilityCodeEnum::toCode).collect(Collectors.toList());
    }
}

