package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信额度查询
 *
 * @author tanbenshuai
 * @date 2024-03-11 13:49
 */
public class CreditQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private CreditDto result;

        @Data
        public static class CreditDto {
            private String taxNo;
            private BigDecimal creditLines;
            private BigDecimal remainAmount;
            private BigDecimal downloadedAmount;
            private BigDecimal unusedAmount;
            private String period;
            private String startCreditLineDate;
            private String endCreditLineDate;
            private String pauseFlag;
            private String creditLinesUpdateTime;
        }
    }
}
