package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 发票版式扩展信息
 * 包含: 纳税人信息 + 纳税人风险信息 + 平台编号 等
 *
 * @author zhouwen
 * @date 2023-10-30 13:43
 */
public class InvoiceVoucherExtendMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        public Result result = new Result();

        @Data
        public static class Result {

            /**
             * 平台编号
             */
            private String platformNo;

            /**
             * 纳税人信息
             */
            private TaxpayerInfoDto taxpayerInfoDto;

            @Data
            public static class TaxpayerInfoDto {

                /**
                 * 税号
                 */
                private String taxNo;

                /**
                 * 纳税人名称
                 */
                private String taxpayerName;

                /**
                 * 纳税人类型标签
                 */
                private String taxpayerTypeTag;

                /**
                 * 出口企业分类
                 */
                private String exportEnterprisesType;

                /**
                 * 企业行业性质
                 */
                private String industryNatureProperties;

                /**
                 * 消费税纳税人类型
                 */
                private String exciseTaxpayerType;

                /**
                 * 纳税人信用等级
                 */
                private String taxpayerRiskLevel;
            }
        }
    }
}
