package com.xforceplus.taxware.chestnut.contract.model;

import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电红字确认单申请
 */
public class RedLetterApplyMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String taskId;

        /**
         * pid
         */
        private String pid;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 录入方身份
         * 0：销方
         * 1：购方
         */
        private String applyIdentity;

        /**
         * 销方信息
         */
        private SellerDto sellerDto;

        /**
         * 购买方信息
         */
        private BuyerDto buyerDto;

        /**
         * 原发票信息
         */
        private OriginalInvoiceDto originalInvoiceDto;

        /**
         * 红字冲销金额
         */
        private BigDecimal reverseAmountWithoutTax;

        /**
         * 红字冲销税额
         */
        private BigDecimal reverseTaxAmount;

        /**
         * 红字发票冲红原因代码
         * 01：开票有误
         * 02：销货退回
         * 03：服务中止
         * 04：销售折让
         */
        private String applyReason;

        /**
         * 明细
         */
        private List<RedLetterApplyDetail> detailList = Lists.newArrayList();

        @Data
        public static class SellerDto {

            /**
             * 销售方纳税人识别号
             * 由数字和大写字母组成。
             */
            private String sellerTaxNo;

            /**
             * 销售方名称
             */
            private String sellerName;
        }

        @Data
        public static class BuyerDto {

            /**
             * 购买方纳税人识别号（非必须）
             */
            private String buyerTaxNo;

            /**
             * 购买方名称
             */
            private String buyerName;
        }

        @Data
        public static class OriginalInvoiceDto {

            /**
             * 蓝字发票代码（非必须）
             */
            private String originalInvoiceCode;

            /**
             * 蓝字发票号码
             */
            private String originalInvoiceNo;

            /**
             * 是否纸质发票标志
             * Y：纸质发票
             * N：电子发票
             */
            private String paperInvoiceFlag;

            /**
             * 蓝字发票开票日期
             * 格式: yyyy-MM-dd HH:mm:ss
             */
            private String originalDateTimeIssued;

            /**
             * 蓝字发票合计金额
             */
            private BigDecimal originalAmountWithoutTax;

            /**
             * 蓝字发票合计税额
             */
            private BigDecimal originalTaxAmount;

            /**
             * 蓝字发票票种代码
             * 01: 增值税专用发票
             * 02: 普通发票
             * 03: 机动车统一销售发票
             * 04: 二手车统一销售发票
             */
            private String originalInvoiceType;

            /**
             * 归集发票类型
             * 01：增值税专用发票
             * 02：货物运输业增值税专用发票
             * 03：机动车销售统一发票
             * 04：增值税普通发票
             * 08：增值税电子专用发票
             * 10：增值税电子普通发票
             * 11：卷式发票
             * 14：通行费发票
             * 15：二手车销售统一发票
             * 81：电子发票（增值税专用发票）
             * 82：电子发票（普通发票）
             * 85：纸质发票（增值税专用发票）
             * 86：纸质发票（普通发票）
             * 51：电子发票（铁路电子客票）
             * 61：电子发票（航空运输客票电子行程单）
             */
            private String collectionOriginalInvoiceType;

            /**
             * 蓝字发票特定要素类型代码（非必须）
             * 01：成品油发票
             * 02：稀土发票
             * 03：建筑服务发票
             * 04：货物运输服务发票
             * 05：不动产销售服务发票
             * 06：不动产租赁服务发票
             * 07：代收车船税
             * 08：通行费
             * 09：旅客运输服务发票
             * 10：医疗服务（住院）发票
             * 11：医疗服务（门诊）发票
             * 12：自产农产品销售发票
             * 13 拖拉机和联合收割机发票
             * 14：机动车
             * 15：二手车
             * 16：农产品收购发票
             * 17：光伏收购发票
             * 18：卷烟发票
             */
            private String originalInvoiceStyleType;
        }

        @Data
        public static class RedLetterApplyDetail {

            /**
             * 蓝字发票明细序号（非必须）
             */
            private Integer originalRowNum;

            /**
             * 序号
             * 8位，从1开始。
             */
            private Integer rowNum;

            /**
             * 商品和服务税收分类合并编码
             */
            private String goodsTaxNo;

            /**
             * 货物或应税劳务、服务名称
             */
            private String itemSimpleName;

            /**
             * 商品服务简称
             */
            private String itemShortName;

            /**
             * 项目名称
             * 格式必须是“*简称*商品名称
             */
            private String itemName;

            /**
             * 规格型号（非必须）
             */
            private String specifications;

            /**
             * 单位（非必须）
             * 如“数量”“单价”栏次非空，则本栏次必须非空
             */
            private String unit;

            /**
             * 单价（非必须）
             * 如“数量”“单位”栏次非空，则本栏次必须非空
             * 文档上还有一个说法，选填（如“单位”非空，则必填）
             */
            private String unitPrice;

            /**
             * 数量（非必须）
             * 如“单价”“单价”栏次非空，则本栏次必须非空
             * 文档上还有一个说法，选填（如“单位”非空，则必填）
             */
            private String quantity;

            /**
             * 金额
             */
            private BigDecimal amountWithoutTax;

            /**
             * 税率
             * 必须在可用税率信息中存在。
             */
            private BigDecimal taxRate;

            /**
             * 税额
             */
            private BigDecimal taxAmount;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String taskId;

            /**
             * pid
             */
            private String pid;

            /**
             * 租户id
             */
            private String tenantId;

            /**
             * 红字确认单编号（非必须）
             */
            private String redLetterNumber;

            /**
             * 红字确认单UUID（非必须）
             */
            private String redLetterUuid;

            /**
             * 红字确认单状态（非必须）
             * 01：无需确认
             * 02：销方录入待购方确认
             * 03：购方录入待销方确认
             * 04：购销双方已确认
             * 05：作废（销方录入购方否认）
             * 06：作废（购方录入销方否认）
             * 07：作废（超72小时未确认）
             * 08：（发起方撤销）
             * 09：作废（确认后撤销）
             * 10作废（异常凭证）
             */
            private String redLetterStatus;
        }
    }
}
