package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 能力编码枚举
 *
 * @author Bobo
 * @create 2023/3/21 10:05
 * @since 1.0.0
 */
public enum CapabilityCodeEnum {

    /**
     * 能力编码
     */
    COMMON("00", 1, "202007", "911001","通用能力"),
    OIL("01", 2, "202055", "999888","成品油"),
    CONSTRUCTION_SERVICE("03", 4, "202044", "202206","建筑服务"),
    FREIGHT_SERVICE("04", 8, "202026", "230207004", "货物运输服务"),
    REAL_ESTATE_SALES("05", 16, "202046", "202204", "不动产销售"),
    REAL_ESTATE_LEASE("06", 32, "202038", "202036", "不动产租赁"),
    PASSENGER_TRANSPORTATION("09", 64, "202027", "230207003", "旅客运输"),
    PRODUCE_SALES("12", 128, "202031", "1234567", "农产品销售"),
    PRODUCE_PURCHASE("16", 256, "202019", "202019", "农产品收购"),
    PHOTOVOLTAIC_ACQUISITION("17", 512, "202017", "202017", "光伏收购"),
    COLLECTION("99", 1024, "203067", "203067", "归集能力"),
    DEDUCTION("100", 2048, "203065", "203065", "增值税抵扣勾选能力"),
    TAX_REFUND_DEDUCTION("101", 4096, "203064", "203064", "增值税退税勾选能力"),
    DEPUTY_TAX_REFUND_DEDUCTION("102", 8192, "203066", "203066", "代办退税勾选能力"),
    ENTRY("103", 16384, "203057", "203057", "发票入账能力"),
    VERIFICATION("104", 32768, "203059", "203059", "发票查验能力");

    private final String code;
    private final int numCode;
    private final String capabilityCode;
    private final String caseCode;
    private final String desc;

    CapabilityCodeEnum(String code, int numCode, String capabilityCode,String caseCode, String desc) {
        this.code = code;
        this.numCode = numCode;
        this.capabilityCode = capabilityCode;
        this.caseCode = caseCode;
        this.desc = desc;
    }

    public String toCode() {
        return this.code;
    }

    public int toNumCode() {
        return this.numCode;
    }

    public String toCapabilityCode() {
        return this.capabilityCode;
    }

    public String toDesc() {
        return this.desc;
    }

    public String toCaseCode() {
        return this.caseCode;
    }

    public static CapabilityCodeEnum fromCode(final String code) {
        return Arrays.stream(CapabilityCodeEnum.values())
                .filter(x -> Objects.equals(x.code, code))
                .findAny()
                .orElse(COMMON);
    }

    public static List<CapabilityCodeEnum> fromCodeList(final List<String> codeList) {
        if (codeList == null) {
            return Arrays.asList(CapabilityCodeEnum.COMMON);
        }

        return codeList.stream().map(x -> CapabilityCodeEnum.fromCode(x)).collect(Collectors.toList());
    }

    public static List<CapabilityCodeEnum> fromNumCode(Integer numCode) {
        if (numCode == null || numCode == 0) {
            return Arrays.asList(CapabilityCodeEnum.COMMON);
        }

        return Arrays.stream(CapabilityCodeEnum.values())
                .filter(x -> (x.numCode & numCode) > 0)
                .collect(Collectors.toList());
    }

    public static int to(List<CapabilityCodeEnum> capabilityCodeEnums) {
        int numCode = 0;
        if (capabilityCodeEnums == null) {
            return CapabilityCodeEnum.COMMON.numCode;
        }

        for (CapabilityCodeEnum capabilityCodeEnum : capabilityCodeEnums) {
            numCode += capabilityCodeEnum.numCode;
        }
        return numCode;
    }

    public static List<String> toCodeList(List<CapabilityCodeEnum> capabilityCodeEnums) {
        if (capabilityCodeEnums == null) {
            return Arrays.asList(CapabilityCodeEnum.COMMON.code);
        }

        return capabilityCodeEnums.stream().map(CapabilityCodeEnum::toCode).collect(Collectors.toList());
    }
}
