package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author zhenmengying
 * @date 2023/3/1
 * @describe:
 */
public enum TaxRateStatusEnum {

    /**
     * 税率状态
     */
    TAX_RATE_STATUS("", "税率可用状态"),
    TAX_RATE_STATUS_0("0", "启用"),
    TAX_RATE_STATUS_1("1", "停用");

    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    TaxRateStatusEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static TaxRateStatusEnum fromStatus(String status) {

        return Arrays.stream(TaxRateStatusEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
