package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 授信额度操作
 *
 * @author Bobo
 * @create 2024/4/15 11:56
 * @since 1.0.0
 */
public class CreditOperationMessage {

    @Data
    public static class Request {

        /**
         * 类型
         * download：下载（默认） sendback：回退
         */
        private String type = "download";

        /**
         * 金额
         */
        private BigDecimal amount;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

    }

}
