package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 属地化 - 红字确认单申请
 *
 * @author zhouwen
 * @date 2024-03-07 20:24
 */
public class LocalRedLetterApplyMessage {

    @Data
    public static class Request {
        private String pid;
        private Boolean isSuspected;
        private String duplicatesUpdateAt;
        private String applyIdentity;
        private SellerDto seller;
        private BuyerDto buyer;
        private OriginalInvoiceDto originalInvoice;
        private BigDecimal redAmount;
        private BigDecimal redTaxAmount;
        private String applyReason;
        private List<DetailDto> details;

        @Data
        public static class SellerDto {
            private String sellerTaxNo;
            private String sellerName;
        }

        @Data
        public static class BuyerDto {
            private String buyerTaxNo;
            private String buyerName;
        }

        @Data
        public static class OriginalInvoiceDto {
            private String allElectricInvoiceNo;
            private String invoiceCode;
            private String invoiceNo;
            private String invoiceFlag;
            private String invoiceDateTime;
            private BigDecimal amountWithoutTax;
            private BigDecimal taxAmount;
            private String invoiceType;
            private String invoiceStyleType;
        }

        @Data
        public static class DetailDto {
            private String originInvoiceRowNum;
            private DetailAmountDto detailAmount;
            private ItemDto item;
            private TaxDto tax;

            @Data
            public static class DetailAmountDto {
                private BigDecimal amountWithoutTax;
                private BigDecimal quantity;
                private BigDecimal taxAmount;
                private BigDecimal amountWithTax;
                private BigDecimal unitPrice;
            }

            @Data
            public static class ItemDto {
                private String itemName;
                private String specifications;
                private String unit;
            }

            @Data
            public static class TaxDto {
                private BigDecimal taxRate;
                private String goodsTaxNo;
            }
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private String redLetterNumber;
            private String redLetterUuid;
            private String status;
            private String dateRedApplied;
        }
    }
}
