package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 属地化 - 红字确认单操作
 *
 * @author zhouwen
 * @date 2024-03-14
 */
public class LocalRedLetterOperateMessage {

    @Data
    public static class Request {

        /**
         * pid
         */
        private String pid;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 确认状态
         */
        private String confirmStatus;

        /**
         * 操作身份
         */
        private String confirmIdentity;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto{
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * pid
             */
            private String pid;

            /**
             * 确认时间
             * 格式：yyyy-MM-dd HH:mm:ss
             */
            private String confirmTime;

            /**
             * 最新状态
             */
            private String latestStatus;
        }
    }
}