package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Thj
 * @createdAt: 2024/6/14 15:14
 * @Description:
 */
public class QueryCreditMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private List<CreditLineInfo> rows;
            private PageDTO pageDto;
        }
    }

    @Data
    public static class CreditLineInfo {

        private Long id;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 租户
         */
        private String tenantId;

        /**
         * 租户Code
         */
        private String tenantCode;

        /**
         * 租户名称
         */
        private String tenantName;

        /**
         * 本月总授信额度
         */
        private BigDecimal amount;

        /**
         * 本月可用授信额度
         */
        private BigDecimal remainAmount;

        /**
         * 已下载额度
         */
        private BigDecimal downloadedAmount;

        /**
         * 已下载未使用额度
         */
        private BigDecimal unusedAmount;

        /**
         * 属期(yyyyMM)
         */
        private String period;

        /**
         * 授信额度使用区间起(yyyyMMdd)
         */
        private String startCreditLineDate;

        /**
         * 授信额度使用区间止(yyyyMMdd)
         */
        private String endCreditLineDate;

        /**
         * 暂停授信标志
         * Y：暂停 N：未暂停
         */
        private String pauseFlag;

        /**
         * 启用标识
         */
        private Boolean status;

        /**
         * 更新时间
         */
        private String updatedAt;
    }
}
