package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Thj
 * @createdAt: 2024/6/14 15:14
 * @Description:
 */
public class QueryInvoiceSummaryMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private List<InvoiceSummaryInfo> rows;
            private PageDTO pageDto;
        }
    }

    @Data
    public static class InvoiceSummaryInfo {

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 租户
         */
        private String tenantId;

        /**
         * 租户Code
         */
        private String tenantCode;

        /**
         * 租户名称
         */
        private String tenantName;

        /**
         * 平台编号
         */
        private String platformNo;

        /**
         * 所属期yyyy-MM
         */
        private String period;

        /**
         * 蓝字发票数量
         */
        private Integer blueInvoiceNum = 0;

        /**
         * 蓝字发票金额
         */
        private BigDecimal blueAmountWithoutTax = new BigDecimal("0.00");

        /**
         * 蓝字发票税额
         */
        private BigDecimal blueAmountTax = new BigDecimal("0.00");

        /**
         * 红字发票数量
         */
        private Integer redInvoiceNum = 0;

        /**
         * 红字发票金额
         */
        private BigDecimal redAmountWithoutTax = new BigDecimal("0.00");

        /**
         * 红字发票税额
         */
        private BigDecimal redAmountTax = new BigDecimal("0.00");

        /**
         * 业务类型
         * 0：确认
         * 1：取消
         */
        private String businessType;

        /**
         * 汇总上传状态 0：初始化 1：上传成功 2：失败
         */
        private String invoiceSummaryStatus;

        /**
         * 处理信息
         */
        private String processMsg;
    }
}
