package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Thj
 * @createdAt: 2024/6/14 15:14
 * @Description:
 */
public class QueryOilInventoryMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private List<OilInventoryInfo> rows;
            private PageDTO pageDto;
        }
    }

    @Data
    public static class OilInventoryInfo {

        private Long id;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 租户
         */
        private String tenantCode;

        /**
         * 租户Id
         */
        private String tenantId;

        /**
         * 租户名称
         */
        private String tenantName;

        /**
         * 商品编码
         */
        private String goodsTaxNo;

        /**
         * 商品简称
         */
        private String itemShortName;

        /**
         * 成品油总库存
         */
        private BigDecimal quantity;

        /**
         * 可使用成品油库存
         */
        private BigDecimal remainQuantity;

        /**
         * 已下载成品油库存
         */
        private BigDecimal downloadedQuantity;

        /**
         * 已下载未使用成品油库存
         */
        private BigDecimal unusedQuantity;

        /**
         * 锁定标志
         * Y：库存已锁定 N：库存未锁定
         */
        private String lockFlag;

        /**
         * 启用标识
         */
        private Boolean status;

    }
}
