package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 查询全电红字确认单列表信息
 */
public class RedLetterSyncMessage {

    @Data
    public static class Request {

        /**
         * 查询身份(01 - 销方, 02 - 购方) [2]
         */
        private String queryIdentity;

        /**
         * 查询身份税号
         */
        private String taxNo;

        /**
         * 录入日期起（非必须）
         * yyyy-MM-dd
         */
        private String startApplyDate;

        /**
         * 录入日期止（非必须）
         * yyyy-MM-dd
         */
        private String endApplyDate;

        /**
         * 页码（非必须）
         */
        private Integer pageNumber;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 红字确认单列表
             */
            private RedLetterPage redLetterPage;

            @Data
            public static class RedLetterPage {

                /**
                 * 页码（非必须）
                 */
                private Integer pageNumber;

                /**
                 * 每页数量（非必须）
                 */
                private Integer pageSize;

                /**
                 * 总数量
                 */
                private Integer total;

                /**
                 * 红字确认信息列表
                 */
                private List<RedLetterDto> redLetterList;

                @Data
                public static class RedLetterDto {

                    /**
                     * 红字确认单UUID
                     */
                    private String redLetterUuid;

                    /**
                     * 蓝字发票号码（非必须）
                     */
                    private String allElectricInvoiceNo;

                    /**
                     * 原蓝票发票代码 (数电纸票、税控票用)（2023-07-17 新增）
                     */
                    private String invoiceCode;

                    /**
                     * 原蓝票发票号码 (数电纸票、税控票用)（2023-07-17 新增）
                     */
                    private String invoiceNo;

                    /**
                     * 原蓝票发票类型：
                     * qc - 全电电普
                     * qs - 全电电专
                     * cz - 全电纸普
                     * sz - 全电纸专
                     * ce - 税控电普
                     * c - 税控纸普
                     * se - 税控电专
                     * s - 税控纸专
                     */
                    private String originalInvoiceType;

                    /**
                     * 蓝字发票开票日期(yyyy-MM-dd HH:mm:ss)
                     */
                    private String dateIssued;

                    /**
                     * 红票发票号码(全电)
                     */
                    private String redInvoiceNo;

                    /**
                     * 红字通知单编号
                     */
                    private String redInformationNo;

                    /**
                     * 红字确认单申请日期，格式yyyy-MM-dd HH:mm:ss
                     */
                    private String applyDate;

                    /**
                     * 红字确认单确认日期，格式yyyy-MM-dd HH:mm:ss
                     */
                    private String confirmTime;

                    /**
                     * 录入方身份: 0-销方,1-购方
                     */
                    private String applyIdentity;

                    /**
                     * 发票金额(不含税)
                     */
                    private BigDecimal redAmount;

                    /**
                     * 发票税额
                     */
                    private BigDecimal redTaxAmount;

                    /**
                     * 冲红原因：
                     * making_error - 开票有误
                     * taxable_service_end - 应税服务中止
                     * sales_allowance - 销售折让
                     * sales_return - 销货退回
                     */
                    private String applyReason;

                    /**
                     * 状态：
                     * 01-无需确认
                     * 02-销方录入待购方确认
                     * 03-购方录入待销方确认
                     * 04-购销双方已确认
                     * 05-作废（销方录入购方否认）
                     * 06-作废（购方录入销方否认）
                     * 07-作废（超72小时未确认）
                     * 08-作废（发起方已撤销）
                     * 09-作废（确认后撤销）
                     * 10-作废（异常凭证）
                     */
                    private String status;

                    /**
                     * 开具状态：1-已开具；0-未开具
                     */
                    private String issuedStatus;

                    /**
                     * 红票开票日期(yyyy-MM-dd HH:mm:ss)
                     */
                    private String redDateIssued;

                    /**
                     * 增值税用途状态：00-已勾选未确认；01-已确认；02-未勾选
                     */
                    private String VATaxPurpose;
                    /**
                     * 消费税用途状态：00-未勾选；01-已勾选
                     */
                    private String excisePurpose;
                    /**
                     * 入账状态：00-未入账；01-已入账
                     */
                    private String inAccountStatus;

                    /**
                     * 销方信息
                     */
                    private SellerDto seller;

                    /**
                     * 购方信息
                     */
                    private BuyerDto buyer;

                    @Data
                    public static class SellerDto {

                        /**
                         * （销售方）统一社会信用代码/纳税人识别号/身份证件号码（非必须）
                         */
                        private String sellerTaxNo;

                        /**
                         * （销售方）名称
                         */
                        private String sellerName;
                    }

                    @Data
                    public static class BuyerDto {

                        /**
                         * （购买方）统一社会信用代码/纳税人识别号/身份证件号码
                         */
                        private String buyerTaxNo;

                        /**
                         * （购买方）名称
                         */
                        private String buyerName;
                    }
                }
            }
        }
    }
}
